/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.datacache.nonkeyed;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.iteration.datacache.nonkeyed.DataCacheReader;
import org.apache.flink.iteration.datacache.nonkeyed.FileSegmentReader;
import org.apache.flink.iteration.datacache.nonkeyed.MemorySegmentWriter;
import org.apache.flink.iteration.datacache.nonkeyed.Segment;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.util.NonClosingInputStreamDecorator;
import org.apache.flink.runtime.util.NonClosingOutputStreamDecorator;
import org.apache.flink.statefun.flink.core.feedback.FeedbackConsumer;
import org.apache.flink.table.runtime.util.MemorySegmentPool;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;

public class DataCacheSnapshot {
    private static final int CURRENT_VERSION = 1;
    private final FileSystem fileSystem;
    @Nullable
    private final Tuple2<Integer, Integer> readerPosition;
    private final List<Segment> segments;

    public DataCacheSnapshot(FileSystem fileSystem, @Nullable Tuple2<Integer, Integer> readerPosition, List<Segment> segments) {
        this.fileSystem = fileSystem;
        this.readerPosition = readerPosition;
        this.segments = segments;
        for (Segment segment : segments) {
            Preconditions.checkArgument((segment.getFsSize() > 0L ? 1 : 0) != 0);
        }
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Nullable
    public Tuple2<Integer, Integer> getReaderPosition() {
        return this.readerPosition;
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public void writeTo(OutputStream checkpointOutputStream) throws IOException {
        block13: {
            try (DataOutputStream dos = new DataOutputStream((OutputStream)new NonClosingOutputStreamDecorator(checkpointOutputStream));){
                dos.writeInt(1);
                dos.writeBoolean(this.readerPosition != null);
                if (this.readerPosition != null) {
                    dos.writeInt((Integer)this.readerPosition.f0);
                    dos.writeInt((Integer)this.readerPosition.f1);
                }
                dos.writeBoolean(this.fileSystem.isDistributedFS());
                if (this.fileSystem.isDistributedFS()) {
                    DataCacheSnapshot.serializeSegments(this.segments, dos);
                    break block13;
                }
                dos.writeInt(this.segments.size());
                for (Segment segment : this.segments) {
                    dos.writeInt(segment.getCount());
                    dos.writeLong(segment.getFsSize());
                    FSDataInputStream inputStream = this.fileSystem.open(segment.getPath());
                    try {
                        IOUtils.copyBytes((InputStream)inputStream, (OutputStream)checkpointOutputStream, (boolean)false);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
            }
        }
    }

    public static <T> void replay(InputStream checkpointInputStream, TypeSerializer<T> serializer, FeedbackConsumer<T> feedbackConsumer) throws Exception {
        try (DataInputStream dis = new DataInputStream((InputStream)new NonClosingInputStreamDecorator(checkpointInputStream));){
            int version = dis.readInt();
            Preconditions.checkState((version == 1 ? 1 : 0) != 0, (Object)"Currently only support version 1");
            DataCacheSnapshot.parseReaderPosition(dis);
            boolean isDistributedFS = dis.readBoolean();
            if (isDistributedFS) {
                List<Segment> segments = DataCacheSnapshot.deserializeSegments(dis);
                DataCacheReader<T> dataCacheReader = new DataCacheReader<T>(serializer, segments);
                while (dataCacheReader.hasNext()) {
                    feedbackConsumer.processFeedback(dataCacheReader.next());
                }
            } else {
                DataInputViewStreamWrapper dataInputView = new DataInputViewStreamWrapper((InputStream)dis);
                int segmentNum = dis.readInt();
                for (int i = 0; i < segmentNum; ++i) {
                    int count = dis.readInt();
                    dis.readLong();
                    for (int j = 0; j < count; ++j) {
                        feedbackConsumer.processFeedback(serializer.deserialize((DataInputView)dataInputView));
                    }
                }
            }
        }
    }

    public static DataCacheSnapshot recover(InputStream checkpointInputStream, FileSystem fileSystem, SupplierWithException<Path, IOException> pathGenerator) throws IOException {
        try (DataInputStream dis = new DataInputStream((InputStream)new NonClosingInputStreamDecorator(checkpointInputStream));){
            List<Segment> segments;
            int version = dis.readInt();
            Preconditions.checkState((version == 1 ? 1 : 0) != 0, (Object)"Currently only support version 1");
            Tuple2<Integer, Integer> readerPosition = DataCacheSnapshot.parseReaderPosition(dis);
            boolean isDistributedFS = dis.readBoolean();
            Preconditions.checkState((isDistributedFS == fileSystem.isDistributedFS() ? 1 : 0) != 0, (Object)"Currently we do not support changing the cache file system. If required, please manually copy the directory from one filesystem to another.");
            if (isDistributedFS) {
                segments = DataCacheSnapshot.deserializeSegments(dis);
            } else {
                int segmentNum = dis.readInt();
                segments = new ArrayList<Segment>(segmentNum);
                for (int i = 0; i < segmentNum; ++i) {
                    int count = dis.readInt();
                    long fsSize = dis.readLong();
                    Path path = (Path)pathGenerator.get();
                    try (FSDataOutputStream outputStream = fileSystem.create(path, FileSystem.WriteMode.NO_OVERWRITE);){
                        BoundedInputStream boundedInputStream = new BoundedInputStream(checkpointInputStream, fsSize);
                        boundedInputStream.setPropagateClose(false);
                        IOUtils.copyBytes((InputStream)boundedInputStream, (OutputStream)outputStream, (boolean)false);
                        boundedInputStream.close();
                    }
                    segments.add(new Segment(path, count, fsSize));
                }
            }
            DataCacheSnapshot dataCacheSnapshot = new DataCacheSnapshot(fileSystem, readerPosition, segments);
            return dataCacheSnapshot;
        }
    }

    public <T> void tryReadSegmentsToMemory(TypeSerializer<T> serializer, MemorySegmentPool segmentPool) throws IOException {
        for (Segment segment : this.segments) {
            MemorySegmentWriter writer;
            if (!segment.getCache().isEmpty()) continue;
            FileSegmentReader<T> reader = new FileSegmentReader<T>(serializer, segment, 0);
            try {
                writer = new MemorySegmentWriter(serializer, segment.getPath(), segmentPool, segment.getFsSize());
            }
            catch (MemoryAllocationException e) {
                break;
            }
            boolean cacheSuccess = true;
            while (cacheSuccess && reader.hasNext()) {
                if (writer.addRecord(reader.next())) continue;
                writer.finish().ifPresent(x -> segmentPool.returnAll(x.getCache()));
                cacheSuccess = false;
            }
            if (!cacheSuccess) continue;
            segment.setCache(writer.finish().get().getCache());
        }
    }

    private static Tuple2<Integer, Integer> parseReaderPosition(DataInputStream dataInputStream) throws IOException {
        Tuple2 readerPosition = null;
        boolean hasReaderPosition = dataInputStream.readBoolean();
        if (hasReaderPosition) {
            readerPosition = new Tuple2((Object)dataInputStream.readInt(), (Object)dataInputStream.readInt());
        }
        return readerPosition;
    }

    private static void serializeSegments(List<Segment> segments, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(segments.size());
        for (Segment segment : segments) {
            dataOutputStream.writeUTF(segment.getPath().toString());
            dataOutputStream.writeInt(segment.getCount());
            dataOutputStream.writeLong(segment.getFsSize());
        }
    }

    private static List<Segment> deserializeSegments(DataInputStream dataInputStream) throws IOException {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        int numberOfSegments = dataInputStream.readInt();
        for (int i = 0; i < numberOfSegments; ++i) {
            segments.add(new Segment(new Path(dataInputStream.readUTF()), dataInputStream.readInt(), dataInputStream.readLong()));
        }
        return segments;
    }
}

