/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.operator.coordinator;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.apache.flink.iteration.IterationID;
import org.apache.flink.iteration.operator.coordinator.SharedProgressAligner;
import org.apache.flink.iteration.operator.coordinator.SharedProgressAlignerListener;
import org.apache.flink.iteration.operator.event.CoordinatorCheckpointEvent;
import org.apache.flink.iteration.operator.event.GloballyAlignedEvent;
import org.apache.flink.iteration.operator.event.SubtaskAlignedEvent;
import org.apache.flink.iteration.operator.event.TerminatingOnInitializeEvent;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;

public class HeadOperatorCoordinator
implements OperatorCoordinator,
SharedProgressAlignerListener {
    private final OperatorCoordinator.Context context;
    private final OperatorCoordinator.SubtaskGateway[] subtaskGateways;
    private final SharedProgressAligner sharedProgressAligner;

    public HeadOperatorCoordinator(OperatorCoordinator.Context context, SharedProgressAligner sharedProgressAligner) {
        this.context = context;
        this.sharedProgressAligner = Objects.requireNonNull(sharedProgressAligner);
        this.subtaskGateways = new OperatorCoordinator.SubtaskGateway[context.currentParallelism()];
        sharedProgressAligner.registerAlignedListener(context.getOperatorId(), this);
    }

    public void start() {
    }

    public void subtaskReady(int subtaskIndex, OperatorCoordinator.SubtaskGateway subtaskGateway) {
        this.subtaskGateways[subtaskIndex] = subtaskGateway;
    }

    public void resetToCheckpoint(long checkpointId, @Nullable byte[] bytes) {
        for (int i = 0; i < this.context.currentParallelism(); ++i) {
            this.sharedProgressAligner.removeProgressInfo(this.context.getOperatorId());
        }
    }

    public void subtaskFailed(int subtaskIndex, @Nullable Throwable throwable) {
        this.sharedProgressAligner.removeProgressInfo(this.context.getOperatorId(), subtaskIndex);
    }

    public void handleEventFromOperator(int subtaskIndex, OperatorEvent operatorEvent) {
        if (operatorEvent instanceof SubtaskAlignedEvent) {
            this.sharedProgressAligner.reportSubtaskProgress(this.context.getOperatorId(), subtaskIndex, (SubtaskAlignedEvent)operatorEvent);
        } else if (operatorEvent instanceof TerminatingOnInitializeEvent) {
            this.sharedProgressAligner.notifyGloballyTerminating();
        } else {
            throw new UnsupportedOperationException("Not supported event: " + operatorEvent);
        }
    }

    public void checkpointCoordinator(long l, CompletableFuture<byte[]> completableFuture) {
        this.sharedProgressAligner.requestCheckpoint(l, this.context.currentParallelism(), completableFuture);
    }

    @Override
    public void onAligned(GloballyAlignedEvent globallyAlignedEvent) {
        for (int i = 0; i < this.context.currentParallelism(); ++i) {
            this.subtaskGateways[i].sendEvent((OperatorEvent)globallyAlignedEvent);
        }
    }

    @Override
    public void onCheckpointAligned(CoordinatorCheckpointEvent coordinatorCheckpointEvent) {
        for (int i = 0; i < this.context.currentParallelism(); ++i) {
            this.subtaskGateways[i].sendEvent((OperatorEvent)coordinatorCheckpointEvent);
        }
    }

    public void close() {
        this.sharedProgressAligner.unregisterListener(this.context.getOperatorId());
    }

    public void notifyCheckpointComplete(long l) {
    }

    public void subtaskReset(int i, long l) {
    }

    public static class HeadOperatorCoordinatorProvider
    implements OperatorCoordinator.Provider {
        private final OperatorID operatorId;
        private final IterationID iterationId;
        private final int totalHeadParallelism;

        public HeadOperatorCoordinatorProvider(OperatorID operatorId, IterationID iterationId, int totalHeadParallelism) {
            this.operatorId = operatorId;
            this.iterationId = iterationId;
            this.totalHeadParallelism = totalHeadParallelism;
        }

        public OperatorID getOperatorId() {
            return this.operatorId;
        }

        public OperatorCoordinator create(OperatorCoordinator.Context context) {
            SharedProgressAligner sharedProgressAligner = SharedProgressAligner.getOrCreate(this.iterationId, this.totalHeadParallelism, context, () -> Executors.newSingleThreadScheduledExecutor(runnable -> {
                Thread thread = new Thread(runnable);
                thread.setName("SharedProgressAligner-" + (Object)((Object)this.iterationId));
                return thread;
            }));
            return new HeadOperatorCoordinator(context, sharedProgressAligner);
        }
    }
}

