/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.proxy;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.iteration.typeinfo.IterationRecordTypeInfo;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.OutputTag;

public class ProxyOutput<T>
implements Output<StreamRecord<T>> {
    private final Output<StreamRecord<IterationRecord<T>>> output;
    private final StreamRecord<IterationRecord<T>> reuseRecord;
    private final Map<String, SideOutputCache> sideOutputCaches = new HashMap<String, SideOutputCache>();
    private Integer contextRound;

    public ProxyOutput(Output<StreamRecord<IterationRecord<T>>> output) {
        this.output = Objects.requireNonNull(output);
        this.reuseRecord = new StreamRecord(IterationRecord.newRecord(null, 0));
    }

    public void setContextRound(Integer contextRound) {
        this.contextRound = contextRound;
    }

    public void emitWatermark(Watermark mark) {
    }

    public void emitWatermarkStatus(WatermarkStatus watermarkStatus) {
        this.output.emitWatermarkStatus(watermarkStatus);
    }

    public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        SideOutputCache sideOutputCache = this.sideOutputCaches.computeIfAbsent(outputTag.getId(), ignored -> new SideOutputCache(new OutputTag(outputTag.getId(), new IterationRecordTypeInfo(outputTag.getTypeInfo())), new StreamRecord(IterationRecord.newRecord(null, 0))));
        sideOutputCache.cachedRecord.replace(IterationRecord.newRecord(record.getValue(), this.contextRound), record.getTimestamp());
        this.output.collect(sideOutputCache.tag, sideOutputCache.cachedRecord);
    }

    public void emitLatencyMarker(LatencyMarker latencyMarker) {
        this.output.emitLatencyMarker(latencyMarker);
    }

    public void collect(StreamRecord<T> record) {
        ((IterationRecord)this.reuseRecord.getValue()).setValue(record.getValue());
        ((IterationRecord)this.reuseRecord.getValue()).setEpoch(this.contextRound);
        this.reuseRecord.setTimestamp(record.getTimestamp());
        this.output.collect(this.reuseRecord);
    }

    public void close() {
        this.output.close();
    }

    private static class SideOutputCache {
        final OutputTag<IterationRecord<?>> tag;
        final StreamRecord<IterationRecord<?>> cachedRecord;

        public SideOutputCache(OutputTag<IterationRecord<?>> tag, StreamRecord<IterationRecord<?>> cachedRecord) {
            this.tag = tag;
            this.cachedRecord = cachedRecord;
        }
    }
}

