/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.classification.logisticregression;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Random;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.ml.classification.logisticregression.LogisticRegressionModelData;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;

public class LogisticRegressionModelDataUtil {
    public static Table generateRandomModelData(StreamTableEnvironment tEnv, int dim, int seed) {
        StreamExecutionEnvironment env = TableUtils.getExecutionEnvironment(tEnv);
        return tEnv.fromDataStream((DataStream)env.fromElements((Object[])new Integer[]{1}).map((MapFunction)new RandomModelDataGenerator(dim, seed)));
    }

    public static DataStream<LogisticRegressionModelData> getModelDataStream(Table modelData) {
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)modelData).getTableEnvironment();
        return tEnv.toDataStream(modelData).map((MapFunction & Serializable)x -> new LogisticRegressionModelData((DenseVector)x.getFieldAs(0), (Long)x.getFieldAs(1)));
    }

    public static DataStream<byte[]> getModelDataByteStream(Table modelDataTable) {
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)modelDataTable).getTableEnvironment();
        return tEnv.toDataStream(modelDataTable).map((MapFunction & Serializable)x -> {
            LogisticRegressionModelData modelData = new LogisticRegressionModelData((DenseVector)x.getFieldAs(0), (Long)x.getFieldAs(1));
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            modelData.encode(outputStream);
            return outputStream.toByteArray();
        });
    }

    public static class ModelDataDecoder
    extends SimpleStreamFormat<LogisticRegressionModelData> {
        public StreamFormat.Reader<LogisticRegressionModelData> createReader(Configuration configuration, final FSDataInputStream inputStream) {
            return new StreamFormat.Reader<LogisticRegressionModelData>(){

                public LogisticRegressionModelData read() throws IOException {
                    try {
                        return LogisticRegressionModelData.decode((InputStream)inputStream);
                    }
                    catch (EOFException e) {
                        return null;
                    }
                }

                public void close() throws IOException {
                    inputStream.close();
                }
            };
        }

        public TypeInformation<LogisticRegressionModelData> getProducedType() {
            return TypeInformation.of(LogisticRegressionModelData.class);
        }
    }

    public static class ModelDataEncoder
    implements Encoder<LogisticRegressionModelData> {
        public void encode(LogisticRegressionModelData modelData, OutputStream outputStream) throws IOException {
            modelData.encode(outputStream);
        }
    }

    private static class RandomModelDataGenerator
    implements MapFunction<Integer, LogisticRegressionModelData> {
        private final int dim;
        private final int seed;

        public RandomModelDataGenerator(int dim, int seed) {
            this.dim = dim;
            this.seed = seed;
        }

        public LogisticRegressionModelData map(Integer integer) throws Exception {
            DenseVector vector = new DenseVector(this.dim);
            Random random = new Random(this.seed);
            for (int j = 0; j < this.dim; ++j) {
                vector.values[j] = random.nextDouble();
            }
            return new LogisticRegressionModelData(vector, 0L);
        }
    }
}

