/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.onehotencoder;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.common.broadcast.BroadcastUtils;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.onehotencoder.OneHotEncoderModelData;
import org.apache.flink.ml.feature.onehotencoder.OneHotEncoderParams;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.ml.linalg.typeinfo.SparseVectorTypeInfo;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class OneHotEncoderModel
implements Model<OneHotEncoderModel>,
OneHotEncoderParams<OneHotEncoderModel> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public OneHotEncoderModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public Table[] transform(Table ... inputs) {
        String[] inputCols = this.getInputCols();
        Object[] outputCols = this.getOutputCols();
        boolean dropLast = this.getDropLast();
        String broadcastModelKey = "OneHotModelStream";
        Preconditions.checkArgument((boolean)this.getHandleInvalid().equals("error"));
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((inputCols.length == outputCols.length ? 1 : 0) != 0);
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo(inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])Collections.nCopies(outputCols.length, SparseVectorTypeInfo.INSTANCE).toArray(new TypeInformation[0])), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])outputCols));
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)this.modelDataTable).getTableEnvironment();
        DataStream input = tEnv.toDataStream(inputs[0]);
        DataStream<Tuple2<Integer, Integer>> modelStream = OneHotEncoderModelData.getModelDataStream(this.modelDataTable);
        Function function = dataStreams -> {
            DataStream stream = (DataStream)dataStreams.get(0);
            return stream.map((MapFunction)new GenerateOutputsFunction(inputCols, dropLast, "OneHotModelStream"), (TypeInformation)outputTypeInfo);
        };
        DataStream output = BroadcastUtils.withBroadcastStream(Collections.singletonList(input), Collections.singletonMap("OneHotModelStream", modelStream), function);
        Table outputTable = tEnv.fromDataStream(output);
        return new Table[]{outputTable};
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
        ReadWriteUtils.saveModelData(OneHotEncoderModelData.getModelDataStream(this.modelDataTable), path, new OneHotEncoderModelData.ModelDataEncoder());
    }

    public static OneHotEncoderModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        OneHotEncoderModel model = (OneHotEncoderModel)ReadWriteUtils.loadStageParam(path);
        Table modelDataTable = ReadWriteUtils.loadModelData(tEnv, path, new OneHotEncoderModelData.ModelDataStreamFormat());
        return model.setModelData(modelDataTable);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    @Override
    public OneHotEncoderModel setModelData(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        this.modelDataTable = inputs[0];
        return this;
    }

    @Override
    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    private static class GenerateOutputsFunction
    extends RichMapFunction<Row, Row> {
        private final String[] inputCols;
        private final boolean dropLast;
        private final String broadcastModelKey;
        private List<Tuple2<Integer, Integer>> model = null;

        public GenerateOutputsFunction(String[] inputCols, boolean dropLast, String broadcastModelKey) {
            this.inputCols = inputCols;
            this.dropLast = dropLast;
            this.broadcastModelKey = broadcastModelKey;
        }

        public Row map(Row row) {
            if (this.model == null) {
                this.model = this.getRuntimeContext().getBroadcastVariable(this.broadcastModelKey);
            }
            int[] categorySizes = new int[this.model.size()];
            int offset = this.dropLast ? 0 : 1;
            for (Tuple2<Integer, Integer> tup : this.model) {
                categorySizes[((Integer)tup.f0).intValue()] = (Integer)tup.f1 + offset;
            }
            Row result = new Row(categorySizes.length);
            for (int i = 0; i < categorySizes.length; ++i) {
                Number number = (Number)row.getField(this.inputCols[i]);
                Preconditions.checkArgument(((double)number.intValue() == number.doubleValue() ? 1 : 0) != 0, (Object)String.format("Value %s cannot be parsed as indexed integer.", number));
                int idx = number.intValue();
                if (idx == categorySizes[i]) {
                    result.setField(i, (Object)Vectors.sparse(categorySizes[i], new int[0], new double[0]));
                    continue;
                }
                result.setField(i, (Object)Vectors.sparse(categorySizes[i], new int[]{idx}, new double[]{1.0}));
            }
            return Row.join((Row)row, (Row[])new Row[]{result});
        }
    }
}

