/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.variancethresholdselector;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.array.IntPrimitiveArraySerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;

public class VarianceThresholdSelectorModelData {
    public int numOfFeatures;
    public int[] indices;

    public VarianceThresholdSelectorModelData() {
    }

    public VarianceThresholdSelectorModelData(int numOfFeatures, int[] indices) {
        this.numOfFeatures = numOfFeatures;
        this.indices = indices;
    }

    public static DataStream<VarianceThresholdSelectorModelData> getModelDataStream(Table modelDataTable) {
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)modelDataTable).getTableEnvironment();
        return tEnv.toDataStream(modelDataTable).map((MapFunction & Serializable)x -> new VarianceThresholdSelectorModelData((Integer)x.getField(0), (int[])x.getField(1)));
    }

    public static class ModelDataDecoder
    extends SimpleStreamFormat<VarianceThresholdSelectorModelData> {
        public StreamFormat.Reader<VarianceThresholdSelectorModelData> createReader(Configuration config, final FSDataInputStream stream) {
            return new StreamFormat.Reader<VarianceThresholdSelectorModelData>(){

                public VarianceThresholdSelectorModelData read() throws IOException {
                    DataInputViewStreamWrapper source = new DataInputViewStreamWrapper((InputStream)stream);
                    try {
                        int numFeatures = IntSerializer.INSTANCE.deserialize((DataInputView)source);
                        int[] indices = IntPrimitiveArraySerializer.INSTANCE.deserialize((DataInputView)source);
                        return new VarianceThresholdSelectorModelData(numFeatures, indices);
                    }
                    catch (EOFException e) {
                        return null;
                    }
                }

                public void close() throws IOException {
                    stream.close();
                }
            };
        }

        public TypeInformation<VarianceThresholdSelectorModelData> getProducedType() {
            return TypeInformation.of(VarianceThresholdSelectorModelData.class);
        }
    }

    public static class ModelDataEncoder
    implements Encoder<VarianceThresholdSelectorModelData> {
        public void encode(VarianceThresholdSelectorModelData modelData, OutputStream outputStream) throws IOException {
            DataOutputViewStreamWrapper dataOutputView = new DataOutputViewStreamWrapper(outputStream);
            IntSerializer.INSTANCE.serialize(Integer.valueOf(modelData.numOfFeatures), (DataOutputView)dataOutputView);
            IntPrimitiveArraySerializer.INSTANCE.serialize(modelData.indices, (DataOutputView)dataOutputView);
        }
    }
}

