/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.vectorslicer;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Transformer;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.vectorslicer.VectorSlicerParams;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.SparseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.typeinfo.VectorTypeInfo;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class VectorSlicer
implements Transformer<VectorSlicer>,
VectorSlicerParams<VectorSlicer> {
    private final Map<Param<?>, Object> paramMap = new HashMap();

    public VectorSlicer() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo(inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{VectorTypeInfo.INSTANCE}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getOutputCol()}));
        SingleOutputStreamOperator output = tEnv.toDataStream(inputs[0]).map((MapFunction)new VectorSliceFunction(this.getIndices(), this.getInputCol()), (TypeInformation)outputTypeInfo);
        Table outputTable = tEnv.fromDataStream((DataStream)output);
        return new Table[]{outputTable};
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
    }

    public static VectorSlicer load(StreamTableEnvironment env, String path) throws IOException {
        return (VectorSlicer)ReadWriteUtils.loadStageParam(path);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    private static class VectorSliceFunction
    implements MapFunction<Row, Row> {
        private final Integer[] indices;
        private final String inputCol;
        private int maxIndex = -1;

        public VectorSliceFunction(Integer[] indices, String inputCol) {
            this.indices = indices;
            for (Integer index : indices) {
                this.maxIndex = Math.max(this.maxIndex, index);
            }
            this.inputCol = inputCol;
        }

        public Row map(Row row) throws Exception {
            Vector outputVec;
            Vector inputVec = (Vector)row.getFieldAs(this.inputCol);
            if (this.maxIndex >= inputVec.size()) {
                throw new IllegalArgumentException("Index value " + this.maxIndex + " is greater than vector size:" + inputVec.size());
            }
            if (inputVec instanceof DenseVector) {
                double[] values = new double[this.indices.length];
                for (int i = 0; i < this.indices.length; ++i) {
                    values[i] = ((DenseVector)inputVec).values[this.indices[i]];
                }
                outputVec = new DenseVector(values);
            } else {
                int nnz = 0;
                SparseVector vec = (SparseVector)inputVec;
                int[] outputIndices = new int[this.indices.length];
                double[] outputValues = new double[this.indices.length];
                for (int i = 0; i < this.indices.length; ++i) {
                    double val = vec.get(this.indices[i]);
                    if (val == 0.0) continue;
                    outputIndices[nnz] = i;
                    outputValues[nnz] = val;
                    ++nnz;
                }
                if (nnz < outputIndices.length) {
                    outputIndices = Arrays.copyOf(outputIndices, nnz);
                    outputValues = Arrays.copyOf(outputValues, nnz);
                }
                outputVec = new SparseVector(this.indices.length, outputIndices, outputValues);
            }
            return Row.join((Row)row, (Row[])new Row[]{Row.of((Object[])new Object[]{outputVec})});
        }
    }
}

