/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.evaluation;

import org.apache.flink.ml.evaluation.binaryclassification.BinaryClassificationEvaluator;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;

public class BinaryClassificationEvaluatorExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource inputStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{1.0, Vectors.dense((double[])new double[]{0.1, 0.9})}), Row.of((Object[])new Object[]{1.0, Vectors.dense((double[])new double[]{0.2, 0.8})}), Row.of((Object[])new Object[]{1.0, Vectors.dense((double[])new double[]{0.3, 0.7})}), Row.of((Object[])new Object[]{0.0, Vectors.dense((double[])new double[]{0.25, 0.75})}), Row.of((Object[])new Object[]{0.0, Vectors.dense((double[])new double[]{0.4, 0.6})}), Row.of((Object[])new Object[]{1.0, Vectors.dense((double[])new double[]{0.35, 0.65})}), Row.of((Object[])new Object[]{1.0, Vectors.dense((double[])new double[]{0.45, 0.55})}), Row.of((Object[])new Object[]{0.0, Vectors.dense((double[])new double[]{0.6, 0.4})}), Row.of((Object[])new Object[]{0.0, Vectors.dense((double[])new double[]{0.7, 0.3})}), Row.of((Object[])new Object[]{1.0, Vectors.dense((double[])new double[]{0.65, 0.35})}), Row.of((Object[])new Object[]{0.0, Vectors.dense((double[])new double[]{0.8, 0.2})}), Row.of((Object[])new Object[]{1.0, Vectors.dense((double[])new double[]{0.9, 0.1})})});
        Table inputTable = tEnv.fromDataStream((DataStream)inputStream).as("label", new String[]{"rawPrediction"});
        BinaryClassificationEvaluator evaluator = (BinaryClassificationEvaluator)new BinaryClassificationEvaluator().setMetricsNames(new String[]{"areaUnderPR", "ks", "areaUnderROC"});
        Table outputTable = evaluator.transform(new Table[]{inputTable})[0];
        Row evaluationResult = (Row)outputTable.execute().collect().next();
        System.out.printf("Area under the precision-recall curve: %s\n", evaluationResult.getField("areaUnderPR"));
        System.out.printf("Area under the receiver operating characteristic curve: %s\n", evaluationResult.getField("areaUnderROC"));
        System.out.printf("Kolmogorov-Smirnov value: %s\n", evaluationResult.getField("ks"));
    }
}

