/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import java.util.Arrays;
import org.apache.flink.ml.feature.imputer.Imputer;
import org.apache.flink.ml.feature.imputer.ImputerModel;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class ImputerExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource trainStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{Double.NaN, 9.0}), Row.of((Object[])new Object[]{1.0, 9.0}), Row.of((Object[])new Object[]{1.5, 9.0}), Row.of((Object[])new Object[]{2.5, Double.NaN}), Row.of((Object[])new Object[]{5.0, 5.0}), Row.of((Object[])new Object[]{5.0, 4.0})});
        Table trainTable = tEnv.fromDataStream((DataStream)trainStream).as("input1", new String[]{"input2"});
        Imputer imputer = (Imputer)((Imputer)((Imputer)((Imputer)new Imputer().setInputCols(new String[]{"input1", "input2"})).setOutputCols(new String[]{"output1", "output2"})).setStrategy("mean")).setMissingValue(Double.NaN);
        ImputerModel model = imputer.fit(new Table[]{trainTable});
        Table outputTable = model.transform(new Table[]{trainTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            double[] inputValues = new double[imputer.getInputCols().length];
            double[] outputValues = new double[imputer.getInputCols().length];
            for (int i = 0; i < inputValues.length; ++i) {
                inputValues[i] = (Double)row.getField(imputer.getInputCols()[i]);
                outputValues[i] = (Double)row.getField(imputer.getOutputCols()[i]);
            }
            System.out.printf("Input Values: %s\tOutput Values: %s\n", Arrays.toString(inputValues), Arrays.toString(outputValues));
        }
    }
}

