/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import org.apache.flink.ml.feature.variancethresholdselector.VarianceThresholdSelector;
import org.apache.flink.ml.feature.variancethresholdselector.VarianceThresholdSelectorModel;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class VarianceThresholdSelectorExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource trainStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{1, Vectors.dense((double[])new double[]{5.0, 7.0, 0.0, 7.0, 6.0, 0.0})}), Row.of((Object[])new Object[]{2, Vectors.dense((double[])new double[]{0.0, 9.0, 6.0, 0.0, 5.0, 9.0})}), Row.of((Object[])new Object[]{3, Vectors.dense((double[])new double[]{0.0, 9.0, 3.0, 0.0, 5.0, 5.0})}), Row.of((Object[])new Object[]{4, Vectors.dense((double[])new double[]{1.0, 9.0, 8.0, 5.0, 7.0, 4.0})}), Row.of((Object[])new Object[]{5, Vectors.dense((double[])new double[]{9.0, 8.0, 6.0, 5.0, 4.0, 4.0})}), Row.of((Object[])new Object[]{6, Vectors.dense((double[])new double[]{6.0, 9.0, 7.0, 0.0, 2.0, 0.0})})});
        Table trainTable = tEnv.fromDataStream((DataStream)trainStream).as("id", new String[]{"input"});
        double threshold = 8.0;
        VarianceThresholdSelector varianceThresholdSelector = (VarianceThresholdSelector)((VarianceThresholdSelector)new VarianceThresholdSelector().setVarianceThreshold(threshold)).setInputCol("input");
        VarianceThresholdSelectorModel model = varianceThresholdSelector.fit(new Table[]{trainTable});
        Table outputTable = model.transform(new Table[]{trainTable})[0];
        System.out.printf("Variance Threshold: %s\n", threshold);
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            DenseVector inputValue = (DenseVector)row.getField(varianceThresholdSelector.getInputCol());
            DenseVector outputValue = (DenseVector)row.getField(varianceThresholdSelector.getOutputCol());
            System.out.printf("Input Values: %-15s\tOutput Values: %s\n", inputValue, outputValue);
        }
    }
}

