/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.ml.linalg.typeinfo;

import org.apache.flink.api.common.typeinfo.TypeInfoFactory;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.ml.linalg.Vector;

import java.lang.reflect.Type;
import java.util.Map;

/** Used by {@link TypeExtractor} to create a {@link TypeInformation} for {@link Vector}. */
public class VectorTypeInfoFactory extends TypeInfoFactory<Vector> {

    @Override
    public TypeInformation<Vector> createTypeInfo(
            Type t, Map<String, TypeInformation<?>> genericParameters) {
        return new VectorTypeInfo();
    }
}
