/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.operator;

import java.util.Objects;
import java.util.function.Consumer;
import org.apache.flink.iteration.IterationID;
import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.iteration.checkpoint.Checkpoints;
import org.apache.flink.iteration.checkpoint.CheckpointsBroker;
import org.apache.flink.iteration.operator.OperatorUtils;
import org.apache.flink.statefun.flink.core.feedback.FeedbackChannel;
import org.apache.flink.statefun.flink.core.feedback.FeedbackChannelBroker;
import org.apache.flink.statefun.flink.core.feedback.FeedbackKey;
import org.apache.flink.statefun.flink.core.feedback.SubtaskFeedbackKey;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.IOUtils;

public class TailOperator
extends AbstractStreamOperator<Void>
implements OneInputStreamOperator<IterationRecord<?>, Void> {
    private final IterationID iterationId;
    private final int feedbackIndex;
    private transient Consumer<StreamRecord<IterationRecord<?>>> recordConsumer;
    private transient FeedbackChannel<StreamRecord<IterationRecord<?>>> channel;

    public TailOperator(IterationID iterationId, int feedbackIndex) {
        this.iterationId = Objects.requireNonNull(iterationId);
        this.feedbackIndex = feedbackIndex;
    }

    public void setup(StreamTask<?, ?> containingTask, StreamConfig config, Output<StreamRecord<Void>> output) {
        super.setup(containingTask, config, output);
    }

    public void open() throws Exception {
        super.open();
        int indexOfThisSubtask = this.getRuntimeContext().getIndexOfThisSubtask();
        int attemptNum = this.getRuntimeContext().getAttemptNumber();
        FeedbackKey feedbackKey = OperatorUtils.createFeedbackKey(this.iterationId, this.feedbackIndex);
        SubtaskFeedbackKey key = feedbackKey.withSubTaskIndex(indexOfThisSubtask, attemptNum);
        FeedbackChannelBroker broker = FeedbackChannelBroker.get();
        this.channel = broker.getChannel(key);
        this.recordConsumer = this.getExecutionConfig().isObjectReuseEnabled() ? this::processIfObjectReuseEnabled : this::processIfObjectReuseNotEnabled;
    }

    public void processElement(StreamRecord<IterationRecord<?>> streamRecord) {
        this.recordConsumer.accept(streamRecord);
    }

    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        super.prepareSnapshotPreBarrier(checkpointId);
        this.channel.put((Object)new StreamRecord(IterationRecord.newBarrier(checkpointId)));
    }

    public void notifyCheckpointAborted(long checkpointId) throws Exception {
        super.notifyCheckpointAborted(checkpointId);
        SubtaskFeedbackKey key = OperatorUtils.createFeedbackKey(this.iterationId, this.feedbackIndex).withSubTaskIndex(this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getAttemptNumber());
        Checkpoints checkpoints = CheckpointsBroker.get().getCheckpoints(key);
        if (checkpoints != null) {
            checkpoints.abort(checkpointId);
        }
    }

    private void processIfObjectReuseEnabled(StreamRecord<IterationRecord<?>> record) {
        Object cloned = ((IterationRecord)record.getValue()).clone();
        ((IterationRecord)cloned).incrementEpoch();
        this.channel.put((Object)new StreamRecord(cloned, record.getTimestamp()));
    }

    private void processIfObjectReuseNotEnabled(StreamRecord<IterationRecord<?>> record) {
        ((IterationRecord)record.getValue()).incrementEpoch();
        this.channel.put((Object)new StreamRecord((Object)((IterationRecord)record.getValue()), record.getTimestamp()));
    }

    public void close() throws Exception {
        IOUtils.closeQuietly(this.channel);
        super.close();
    }
}

