/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.operator.headprocessor;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.iteration.operator.OperatorUtils;
import org.apache.flink.iteration.operator.event.GloballyAlignedEvent;
import org.apache.flink.iteration.operator.headprocessor.HeadOperatorRecordProcessor;
import org.apache.flink.iteration.operator.headprocessor.HeadOperatorState;
import org.apache.flink.runtime.state.StatePartitionStreamProvider;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegularHeadOperatorRecordProcessor
implements HeadOperatorRecordProcessor {
    protected static final Logger LOG = LoggerFactory.getLogger(RegularHeadOperatorRecordProcessor.class);
    private final HeadOperatorRecordProcessor.Context headOperatorContext;
    private final Map<Integer, Long> numFeedbackRecordsPerEpoch;
    private final String senderId;
    private int latestRoundAligned;
    private int latestRoundGloballyAligned;

    public RegularHeadOperatorRecordProcessor(HeadOperatorRecordProcessor.Context headOperatorContext) {
        this.headOperatorContext = headOperatorContext;
        this.numFeedbackRecordsPerEpoch = new HashMap<Integer, Long>();
        this.senderId = OperatorUtils.getUniqueSenderId(headOperatorContext.getStreamConfig().getOperatorID(), headOperatorContext.getTaskInfo().getIndexOfThisSubtask());
        this.latestRoundAligned = -1;
        this.latestRoundGloballyAligned = -1;
    }

    @Override
    public void initializeState(HeadOperatorState headOperatorState, Iterable<StatePartitionStreamProvider> rawStates) {
        Preconditions.checkArgument((headOperatorState != null ? 1 : 0) != 0, (Object)"The initialized state should not be null");
        this.numFeedbackRecordsPerEpoch.putAll(headOperatorState.getNumFeedbackRecordsEachRound());
        this.latestRoundAligned = headOperatorState.getLatestRoundAligned();
        this.latestRoundGloballyAligned = headOperatorState.getLatestRoundGloballyAligned();
        if (this.latestRoundAligned != 0 || this.latestRoundGloballyAligned != -1) {
            for (int i = this.latestRoundGloballyAligned + 1; i <= this.latestRoundAligned; ++i) {
                this.headOperatorContext.updateEpochToCoordinator(i, this.numFeedbackRecordsPerEpoch.getOrDefault(i, 0L));
            }
        }
    }

    @Override
    public void processElement(StreamRecord<IterationRecord<?>> element) {
        this.processRecord(element);
    }

    @Override
    public boolean processFeedbackElement(StreamRecord<IterationRecord<?>> element) {
        if (((IterationRecord)element.getValue()).getType() == IterationRecord.Type.RECORD) {
            this.numFeedbackRecordsPerEpoch.compute(((IterationRecord)element.getValue()).getEpoch(), (epoch, count) -> count == null ? 1L : count + 1L);
        }
        this.processRecord(element);
        return false;
    }

    @Override
    public boolean onGloballyAligned(GloballyAlignedEvent globallyAlignedEvent) {
        LOG.info("Received global event {}", (Object)globallyAlignedEvent);
        Preconditions.checkState((globallyAlignedEvent.getEpoch() == 0 && this.latestRoundGloballyAligned == 0 || globallyAlignedEvent.getEpoch() > this.latestRoundGloballyAligned ? 1 : 0) != 0, (Object)String.format("Receive unexpected global aligned event, latest = %d, this one = %d", this.latestRoundGloballyAligned, globallyAlignedEvent.getEpoch()));
        StreamRecord record = new StreamRecord(IterationRecord.newEpochWatermark(globallyAlignedEvent.isTerminated() ? Integer.MAX_VALUE : globallyAlignedEvent.getEpoch(), this.senderId), 0L);
        this.headOperatorContext.broadcastOutput(record);
        this.latestRoundGloballyAligned = Math.max(globallyAlignedEvent.getEpoch(), this.latestRoundGloballyAligned);
        return globallyAlignedEvent.isTerminated();
    }

    @Override
    public HeadOperatorState snapshotState() {
        return new HeadOperatorState(new HashMap<Integer, Long>(this.numFeedbackRecordsPerEpoch), this.latestRoundAligned, this.latestRoundGloballyAligned);
    }

    @VisibleForTesting
    public Map<Integer, Long> getNumFeedbackRecordsPerEpoch() {
        return this.numFeedbackRecordsPerEpoch;
    }

    @VisibleForTesting
    public int getLatestRoundAligned() {
        return this.latestRoundAligned;
    }

    @VisibleForTesting
    public int getLatestRoundGloballyAligned() {
        return this.latestRoundGloballyAligned;
    }

    private void processRecord(StreamRecord<IterationRecord<?>> iterationRecord) {
        switch (((IterationRecord)iterationRecord.getValue()).getType()) {
            case RECORD: {
                this.headOperatorContext.output(iterationRecord);
                break;
            }
            case EPOCH_WATERMARK: {
                LOG.info("Head Received epoch watermark {}", (Object)((IterationRecord)iterationRecord.getValue()).getEpoch());
                boolean needNotifyCoordinator = false;
                if (((IterationRecord)iterationRecord.getValue()).getEpoch() == 0) {
                    if (this.latestRoundAligned <= 0) {
                        needNotifyCoordinator = true;
                    }
                } else {
                    Preconditions.checkState((((IterationRecord)iterationRecord.getValue()).getEpoch() > this.latestRoundAligned ? 1 : 0) != 0, (Object)String.format("Unexpected epoch watermark: latest = %d, this one = %d", this.latestRoundAligned, ((IterationRecord)iterationRecord.getValue()).getEpoch()));
                    this.headOperatorContext.updateEpochToCoordinator(((IterationRecord)iterationRecord.getValue()).getEpoch(), this.numFeedbackRecordsPerEpoch.getOrDefault(((IterationRecord)iterationRecord.getValue()).getEpoch(), 0L));
                }
                if (needNotifyCoordinator) {
                    this.headOperatorContext.updateEpochToCoordinator(((IterationRecord)iterationRecord.getValue()).getEpoch(), this.numFeedbackRecordsPerEpoch.getOrDefault(((IterationRecord)iterationRecord.getValue()).getEpoch(), 0L));
                }
                this.latestRoundAligned = Math.max(((IterationRecord)iterationRecord.getValue()).getEpoch(), this.latestRoundAligned);
            }
        }
    }
}

