/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.benchmark.datagenerator.common;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.benchmark.datagenerator.common.InputTableGenerator;
import org.apache.flink.ml.benchmark.datagenerator.common.RowGenerator;
import org.apache.flink.ml.benchmark.datagenerator.param.HasVectorDim;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class DenseVectorGenerator
extends InputTableGenerator<DenseVectorGenerator>
implements HasVectorDim<DenseVectorGenerator> {
    @Override
    public RowGenerator[] getRowGenerators() {
        final String[][] columnNames = this.getColNames();
        Preconditions.checkState((columnNames.length == 1 ? 1 : 0) != 0);
        Preconditions.checkState((columnNames[0].length == 1 ? 1 : 0) != 0);
        final int vectorDim = this.getVectorDim();
        return new RowGenerator[]{new RowGenerator(this.getNumValues(), this.getSeed()){

            @Override
            protected Row getRow() {
                double[] values = new double[vectorDim];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.random.nextDouble();
                }
                return Row.of((Object[])new Object[]{Vectors.dense(values)});
            }

            @Override
            protected RowTypeInfo getRowTypeInfo() {
                return new RowTypeInfo(new TypeInformation[]{DenseVectorTypeInfo.INSTANCE}, columnNames[0]);
            }
        }};
    }
}

