/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.benchmark.datagenerator.common;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.ml.benchmark.datagenerator.InputDataGenerator;
import org.apache.flink.ml.benchmark.datagenerator.common.RowGenerator;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;

public abstract class InputTableGenerator<T extends InputTableGenerator<T>>
implements InputDataGenerator<T> {
    protected final Map<Param<?>, Object> paramMap = new HashMap();

    public InputTableGenerator() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public final Table[] getData(StreamTableEnvironment tEnv) {
        StreamExecutionEnvironment env = TableUtils.getExecutionEnvironment(tEnv);
        RowGenerator[] rowGenerators = this.getRowGenerators();
        Table[] dataTables = new Table[rowGenerators.length];
        for (int i = 0; i < rowGenerators.length; ++i) {
            SingleOutputStreamOperator dataStream = env.addSource((SourceFunction)rowGenerators[i], "sourceOp-" + i).returns((TypeInformation)rowGenerators[i].getRowTypeInfo());
            dataTables[i] = tEnv.fromDataStream((DataStream)dataStream);
        }
        return dataTables;
    }

    protected abstract RowGenerator[] getRowGenerators();

    @Override
    public final Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }
}

