/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.countvectorizer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.common.broadcast.BroadcastUtils;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.countvectorizer.CountVectorizerModelData;
import org.apache.flink.ml.feature.countvectorizer.CountVectorizerModelParams;
import org.apache.flink.ml.linalg.SparseVector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.ml.linalg.typeinfo.SparseVectorTypeInfo;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class CountVectorizerModel
implements Model<CountVectorizerModel>,
CountVectorizerModelParams<CountVectorizerModel> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public CountVectorizerModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public CountVectorizerModel setModelData(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        this.modelDataTable = inputs[0];
        return this;
    }

    @Override
    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
        ReadWriteUtils.saveModelData(CountVectorizerModelData.getModelDataStream(this.modelDataTable), path, new CountVectorizerModelData.ModelDataEncoder());
    }

    public static CountVectorizerModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        CountVectorizerModel model = (CountVectorizerModel)ReadWriteUtils.loadStageParam(path);
        Table modelDataTable = ReadWriteUtils.loadModelData(tEnv, path, new CountVectorizerModelData.ModelDataDecoder());
        return model.setModelData(modelDataTable);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    @Override
    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        DataStream dataStream = tEnv.toDataStream(inputs[0]);
        DataStream<CountVectorizerModelData> modelDataStream = CountVectorizerModelData.getModelDataStream(this.modelDataTable);
        String broadcastModelKey = "broadcastModelKey";
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo(inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{SparseVectorTypeInfo.INSTANCE}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getOutputCol()}));
        DataStream output = BroadcastUtils.withBroadcastStream(Collections.singletonList(dataStream), Collections.singletonMap("broadcastModelKey", modelDataStream), inputList -> {
            DataStream input = (DataStream)inputList.get(0);
            return input.map((MapFunction)new PredictOutputFunction(this.getInputCol(), "broadcastModelKey", this.getMinTF(), this.getBinary()), (TypeInformation)outputTypeInfo);
        });
        return new Table[]{tEnv.fromDataStream(output)};
    }

    private static class PredictOutputFunction
    extends RichMapFunction<Row, Row> {
        private final String inputCol;
        private final String broadcastKey;
        private final double minTF;
        private final boolean binary;
        private Map<String, Integer> vocabulary;

        public PredictOutputFunction(String inputCol, String broadcastKey, double minTF, boolean binary) {
            this.inputCol = inputCol;
            this.broadcastKey = broadcastKey;
            this.minTF = minTF;
            this.binary = binary;
        }

        public Row map(Row row) throws Exception {
            if (this.vocabulary == null) {
                CountVectorizerModelData modelData = (CountVectorizerModelData)this.getRuntimeContext().getBroadcastVariable(this.broadcastKey).get(0);
                this.vocabulary = new HashMap<String, Integer>();
                IntStream.range(0, modelData.vocabulary.length).forEach(i -> this.vocabulary.put(modelData.vocabulary[i], i));
            }
            String[] document = (String[])row.getField(this.inputCol);
            double[] termCounts = new double[this.vocabulary.size()];
            for (String word : document) {
                if (!this.vocabulary.containsKey(word)) continue;
                int n = this.vocabulary.get(word);
                termCounts[n] = termCounts[n] + 1.0;
            }
            double actualMinTF = this.minTF >= 1.0 ? this.minTF : (double)document.length * this.minTF;
            ArrayList<Integer> indices = new ArrayList<Integer>();
            ArrayList<Double> values = new ArrayList<Double>();
            for (int i2 = 0; i2 < termCounts.length; ++i2) {
                if (!(termCounts[i2] >= actualMinTF)) continue;
                indices.add(i2);
                if (this.binary) {
                    values.add(1.0);
                    continue;
                }
                values.add(termCounts[i2]);
            }
            SparseVector outputVec = Vectors.sparse(termCounts.length, indices.stream().mapToInt(i -> i).toArray(), values.stream().mapToDouble(i -> i).toArray());
            return Row.join((Row)row, (Row[])new Row[]{Row.of((Object[])new Object[]{outputVec})});
        }
    }
}

