/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.robustscaler;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.common.broadcast.BroadcastUtils;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.robustscaler.RobustScalerModelData;
import org.apache.flink.ml.feature.robustscaler.RobustScalerModelParams;
import org.apache.flink.ml.linalg.BLAS;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.typeinfo.VectorTypeInfo;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class RobustScalerModel
implements Model<RobustScalerModel>,
RobustScalerModelParams<RobustScalerModel> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public RobustScalerModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        DataStream inputStream = tEnv.toDataStream(inputs[0]);
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo(inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{VectorTypeInfo.INSTANCE}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getOutputCol()}));
        String broadcastModelKey = "broadcastModelKey";
        DataStream<RobustScalerModelData> modelDataStream = RobustScalerModelData.getModelDataStream(this.modelDataTable);
        DataStream output = BroadcastUtils.withBroadcastStream(Collections.singletonList(inputStream), Collections.singletonMap("broadcastModelKey", modelDataStream), inputList -> {
            DataStream inputData = (DataStream)inputList.get(0);
            return inputData.map((MapFunction)new PredictOutputFunction("broadcastModelKey", this.getInputCol(), this.getWithCentering(), this.getWithScaling()), (TypeInformation)outputTypeInfo);
        });
        return new Table[]{tEnv.fromDataStream(output)};
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
        ReadWriteUtils.saveModelData(RobustScalerModelData.getModelDataStream(this.modelDataTable), path, new RobustScalerModelData.ModelDataEncoder());
    }

    public static RobustScalerModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        RobustScalerModel model = (RobustScalerModel)ReadWriteUtils.loadStageParam(path);
        Table modelDataTable = ReadWriteUtils.loadModelData(tEnv, path, new RobustScalerModelData.ModelDataDecoder());
        return model.setModelData(modelDataTable);
    }

    @Override
    public RobustScalerModel setModelData(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        this.modelDataTable = inputs[0];
        return this;
    }

    @Override
    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    private static class PredictOutputFunction
    extends RichMapFunction<Row, Row> {
        private final String broadcastModelKey;
        private final String inputCol;
        private final boolean withCentering;
        private final boolean withScaling;
        private DenseVector medians;
        private DenseVector scales;

        public PredictOutputFunction(String broadcastModelKey, String inputCol, boolean withCentering, boolean withScaling) {
            this.broadcastModelKey = broadcastModelKey;
            this.inputCol = inputCol;
            this.withCentering = withCentering;
            this.withScaling = withScaling;
        }

        public Row map(Row row) throws Exception {
            if (this.medians == null) {
                RobustScalerModelData modelData = (RobustScalerModelData)this.getRuntimeContext().getBroadcastVariable(this.broadcastModelKey).get(0);
                this.medians = modelData.medians;
                this.scales = new DenseVector(Arrays.stream(modelData.ranges.values).map((double range) -> range == 0.0 ? 0.0 : 1.0 / range).toArray());
            }
            DenseVector outputVec = ((Vector)row.getField(this.inputCol)).clone().toDense();
            Preconditions.checkState((this.medians.size() == outputVec.size() ? 1 : 0) != 0, (String)"Number of features must be %s but got %s.", (Object[])new Object[]{this.medians.size(), outputVec.size()});
            if (this.withCentering) {
                BLAS.axpy(-1.0, this.medians, outputVec);
            }
            if (this.withScaling) {
                BLAS.hDot((Vector)this.scales, (Vector)outputVec);
            }
            return Row.join((Row)row, (Row[])new Row[]{Row.of((Object[])new Object[]{outputVec})});
        }
    }
}

