/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.stringindexer;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.array.StringArraySerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;

public class StringIndexerModelData {
    public String[][] stringArrays;

    public StringIndexerModelData(String[][] stringArrays) {
        this.stringArrays = stringArrays;
    }

    public StringIndexerModelData() {
    }

    public static DataStream<StringIndexerModelData> getModelDataStream(Table modelData) {
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)modelData).getTableEnvironment();
        return tEnv.toDataStream(modelData).map((MapFunction & Serializable)x -> new StringIndexerModelData((String[][])x.getField(0)));
    }

    public static class ModelDataDecoder
    extends SimpleStreamFormat<StringIndexerModelData> {
        public StreamFormat.Reader<StringIndexerModelData> createReader(Configuration configuration, final FSDataInputStream inputStream) {
            return new StreamFormat.Reader<StringIndexerModelData>(){

                public StringIndexerModelData read() throws IOException {
                    try {
                        DataInputViewStreamWrapper inputViewStreamWrapper = new DataInputViewStreamWrapper((InputStream)inputStream);
                        int numCols = IntSerializer.INSTANCE.deserialize((DataInputView)inputViewStreamWrapper);
                        String[][] stringsArray = new String[numCols][];
                        for (int i = 0; i < numCols; ++i) {
                            stringsArray[i] = StringArraySerializer.INSTANCE.deserialize((DataInputView)inputViewStreamWrapper);
                        }
                        return new StringIndexerModelData(stringsArray);
                    }
                    catch (EOFException e) {
                        return null;
                    }
                }

                public void close() throws IOException {
                    inputStream.close();
                }
            };
        }

        public TypeInformation<StringIndexerModelData> getProducedType() {
            return TypeInformation.of(StringIndexerModelData.class);
        }
    }

    public static class ModelDataEncoder
    implements Encoder<StringIndexerModelData> {
        public void encode(StringIndexerModelData modelData, OutputStream outputStream) throws IOException {
            DataOutputViewStreamWrapper outputViewStreamWrapper = new DataOutputViewStreamWrapper(outputStream);
            IntSerializer.INSTANCE.serialize(Integer.valueOf(modelData.stringArrays.length), (DataOutputView)outputViewStreamWrapper);
            for (String[] strings : modelData.stringArrays) {
                StringArraySerializer.INSTANCE.serialize(strings, (DataOutputView)outputViewStreamWrapper);
            }
        }
    }
}

