/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.univariatefeatureselector;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.common.broadcast.BroadcastUtils;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.common.util.VectorUtils;
import org.apache.flink.ml.feature.univariatefeatureselector.UnivariateFeatureSelectorModelData;
import org.apache.flink.ml.feature.univariatefeatureselector.UnivariateFeatureSelectorModelParams;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.ml.linalg.typeinfo.VectorTypeInfo;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class UnivariateFeatureSelectorModel
implements Model<UnivariateFeatureSelectorModel>,
UnivariateFeatureSelectorModelParams<UnivariateFeatureSelectorModel> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public UnivariateFeatureSelectorModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public UnivariateFeatureSelectorModel setModelData(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        this.modelDataTable = inputs[0];
        return this;
    }

    @Override
    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    @Override
    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        DataStream data = tEnv.toDataStream(inputs[0]);
        DataStream<UnivariateFeatureSelectorModelData> modelData = UnivariateFeatureSelectorModelData.getModelDataStream(this.modelDataTable);
        String broadcastModelKey = "broadcastModelKey";
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo(inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{VectorTypeInfo.INSTANCE}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getOutputCol()}));
        DataStream outputStream = BroadcastUtils.withBroadcastStream(Collections.singletonList(data), Collections.singletonMap("broadcastModelKey", modelData), inputList -> {
            DataStream input = (DataStream)inputList.get(0);
            return input.map((MapFunction)new PredictOutputFunction(this.getFeaturesCol(), "broadcastModelKey"), (TypeInformation)outputTypeInfo);
        });
        return new Table[]{tEnv.fromDataStream(outputStream)};
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
        ReadWriteUtils.saveModelData(UnivariateFeatureSelectorModelData.getModelDataStream(this.modelDataTable), path, new UnivariateFeatureSelectorModelData.ModelDataEncoder());
    }

    public static UnivariateFeatureSelectorModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        UnivariateFeatureSelectorModel model = (UnivariateFeatureSelectorModel)ReadWriteUtils.loadStageParam(path);
        Table modelDataTable = ReadWriteUtils.loadModelData(tEnv, path, new UnivariateFeatureSelectorModelData.ModelDataDecoder());
        return model.setModelData(modelDataTable);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    private static class PredictOutputFunction
    extends RichMapFunction<Row, Row> {
        private final String inputCol;
        private final String broadcastKey;
        private int[] indices;

        public PredictOutputFunction(String inputCol, String broadcastKey) {
            this.inputCol = inputCol;
            this.broadcastKey = broadcastKey;
        }

        public Row map(Row row) {
            if (this.indices == null) {
                UnivariateFeatureSelectorModelData modelData = (UnivariateFeatureSelectorModelData)this.getRuntimeContext().getBroadcastVariable(this.broadcastKey).get(0);
                this.indices = Arrays.stream(modelData.indices).sorted().toArray();
            }
            if (this.indices.length == 0) {
                return Row.join((Row)row, (Row[])new Row[]{Row.of((Object[])new Object[]{Vectors.dense(new double[0])})});
            }
            Vector inputVec = (Vector)row.getField(this.inputCol);
            Preconditions.checkArgument((inputVec.size() > this.indices[this.indices.length - 1] ? 1 : 0) != 0, (String)"Input %s features, but UnivariateFeatureSelector is expecting at least %s features as input.", (Object[])new Object[]{inputVec.size(), this.indices[this.indices.length - 1] + 1});
            Vector outputVec = VectorUtils.selectByIndices(inputVec, this.indices);
            return Row.join((Row)row, (Row[])new Row[]{Row.of((Object[])new Object[]{outputVec})});
        }
    }
}

