/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.linalg;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInfo;
import org.apache.flink.ml.linalg.Matrix;
import org.apache.flink.ml.linalg.typeinfo.DenseMatrixTypeInfoFactory;
import org.apache.flink.util.Preconditions;

@TypeInfo(value=DenseMatrixTypeInfoFactory.class)
@PublicEvolving
public class DenseMatrix
implements Matrix {
    private final int numRows;
    private final int numCols;
    public final double[] values;

    public DenseMatrix(int numRows, int numCols) {
        this(numRows, numCols, new double[numRows * numCols]);
    }

    public DenseMatrix(int numRows, int numCols, double[] values) {
        Preconditions.checkArgument((values.length == numRows * numCols ? 1 : 0) != 0);
        this.numRows = numRows;
        this.numCols = numCols;
        this.values = values;
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numCols() {
        return this.numCols;
    }

    @Override
    public double get(int i, int j) {
        Preconditions.checkArgument((i >= 0 && i < this.numRows && j >= 0 && j < this.numCols ? 1 : 0) != 0);
        return this.values[this.numRows * j + i];
    }

    @Override
    public DenseMatrix toDense() {
        return this;
    }
}

