/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.param;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.ml.common.window.CountTumblingWindows;
import org.apache.flink.ml.common.window.EventTimeSessionWindows;
import org.apache.flink.ml.common.window.EventTimeTumblingWindows;
import org.apache.flink.ml.common.window.GlobalWindows;
import org.apache.flink.ml.common.window.ProcessingTimeSessionWindows;
import org.apache.flink.ml.common.window.ProcessingTimeTumblingWindows;
import org.apache.flink.ml.common.window.Windows;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.ParamValidator;

public class WindowsParam
extends Param<Windows> {
    public WindowsParam(String name, String description, Windows defaultValue, ParamValidator<Windows> validator) {
        super(name, Windows.class, description, defaultValue, validator);
    }

    @Override
    public Object jsonEncode(Windows value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("class", value.getClass().getName());
        if (value instanceof GlobalWindows) {
            return map;
        }
        if (value instanceof CountTumblingWindows) {
            map.put("size", ((CountTumblingWindows)value).getSize());
        } else if (value instanceof ProcessingTimeTumblingWindows) {
            map.put("size", ((ProcessingTimeTumblingWindows)value).getSize().toMilliseconds());
        } else if (value instanceof EventTimeTumblingWindows) {
            map.put("size", ((EventTimeTumblingWindows)value).getSize().toMilliseconds());
        } else if (value instanceof ProcessingTimeSessionWindows) {
            map.put("gap", ((ProcessingTimeSessionWindows)value).getGap().toMilliseconds());
        } else if (value instanceof EventTimeSessionWindows) {
            map.put("gap", ((EventTimeSessionWindows)value).getGap().toMilliseconds());
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported %s subclass: %s", Windows.class, value.getClass()));
        }
        return map;
    }

    @Override
    public Windows jsonDecode(Object json) {
        Map map = (Map)json;
        String classString = (String)map.get("class");
        if (classString.equals(GlobalWindows.class.getName())) {
            return GlobalWindows.getInstance();
        }
        if (classString.equals(CountTumblingWindows.class.getName())) {
            long size = ((Number)map.get("size")).longValue();
            return CountTumblingWindows.of(size);
        }
        if (classString.equals(ProcessingTimeTumblingWindows.class.getName())) {
            Time size = Time.milliseconds((long)((Number)map.get("size")).longValue());
            return ProcessingTimeTumblingWindows.of(size);
        }
        if (classString.equals(EventTimeTumblingWindows.class.getName())) {
            Time size = Time.milliseconds((long)((Number)map.get("size")).longValue());
            return EventTimeTumblingWindows.of(size);
        }
        if (classString.equals(ProcessingTimeSessionWindows.class.getName())) {
            Time gap = Time.milliseconds((long)((Number)map.get("gap")).longValue());
            return ProcessingTimeSessionWindows.withGap(gap);
        }
        if (classString.equals(EventTimeSessionWindows.class.getName())) {
            Time gap = Time.milliseconds((long)((Number)map.get("gap")).longValue());
            return EventTimeSessionWindows.withGap(gap);
        }
        throw new UnsupportedOperationException(String.format("Unsupported %s subclass: %s", Windows.class, classString));
    }
}

