/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.regression.linearregression;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.common.broadcast.BroadcastUtils;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.linalg.BLAS;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.regression.linearregression.LinearRegressionModelData;
import org.apache.flink.ml.regression.linearregression.LinearRegressionModelParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class LinearRegressionModel
implements Model<LinearRegressionModel>,
LinearRegressionModelParams<LinearRegressionModel> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public LinearRegressionModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        DataStream inputStream = tEnv.toDataStream(inputs[0]);
        String broadcastModelKey = "broadcastModelKey";
        DataStream<LinearRegressionModelData> modelDataStream = LinearRegressionModelData.getModelDataStream(this.modelDataTable);
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo(inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{BasicTypeInfo.DOUBLE_TYPE_INFO}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getPredictionCol()}));
        DataStream predictionResult = BroadcastUtils.withBroadcastStream(Collections.singletonList(inputStream), Collections.singletonMap("broadcastModelKey", modelDataStream), inputList -> {
            DataStream inputData = (DataStream)inputList.get(0);
            return inputData.map((MapFunction)new PredictLabelFunction("broadcastModelKey", this.getFeaturesCol()), (TypeInformation)outputTypeInfo);
        });
        return new Table[]{tEnv.fromDataStream(predictionResult)};
    }

    @Override
    public LinearRegressionModel setModelData(Table ... inputs) {
        this.modelDataTable = inputs[0];
        return this;
    }

    @Override
    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
        ReadWriteUtils.saveModelData(LinearRegressionModelData.getModelDataStream(this.modelDataTable), path, new LinearRegressionModelData.ModelDataEncoder());
    }

    public static LinearRegressionModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        LinearRegressionModel model = (LinearRegressionModel)ReadWriteUtils.loadStageParam(path);
        Table modelDataTable = ReadWriteUtils.loadModelData(tEnv, path, new LinearRegressionModelData.ModelDataDecoder());
        return model.setModelData(modelDataTable);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    private static Row predictOneDataPoint(DenseVector feature, DenseVector coefficient) {
        return Row.of((Object[])new Object[]{BLAS.dot((Vector)feature, (Vector)coefficient)});
    }

    private static class PredictLabelFunction
    extends RichMapFunction<Row, Row> {
        private final String broadcastModelKey;
        private final String featuresCol;
        private DenseVector coefficient;

        public PredictLabelFunction(String broadcastModelKey, String featuresCol) {
            this.broadcastModelKey = broadcastModelKey;
            this.featuresCol = featuresCol;
        }

        public Row map(Row dataPoint) {
            if (this.coefficient == null) {
                LinearRegressionModelData modelData = (LinearRegressionModelData)this.getRuntimeContext().getBroadcastVariable(this.broadcastModelKey).get(0);
                this.coefficient = modelData.coefficient;
            }
            DenseVector features = ((Vector)dataPoint.getField(this.featuresCol)).toDense();
            Row predictionResult = LinearRegressionModel.predictOneDataPoint(features, this.coefficient);
            return Row.join((Row)dataPoint, (Row[])new Row[]{predictionResult});
        }
    }
}

