/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.backpressure;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashMap;
import java.util.Objects;
import org.apache.flink.statefun.flink.core.backpressure.BackPressureValve;
import org.apache.flink.statefun.sdk.Address;

public final class ThresholdBackPressureValve
implements BackPressureValve {
    private final int maximumPendingAsynchronousOperations;
    private final ObjectOpenHashMap<Address, Boolean> blockedAddressSet = new ObjectOpenHashMap(1024);
    private int pendingAsynchronousOperationsCount;

    public ThresholdBackPressureValve(int maximumPendingAsynchronousOperations) {
        this.maximumPendingAsynchronousOperations = maximumPendingAsynchronousOperations;
    }

    @Override
    public boolean shouldBackPressure() {
        return this.totalPendingAsyncOperationsAtCapacity() || this.hasBlockedAddress();
    }

    @Override
    public void blockAddress(Address address) {
        Objects.requireNonNull(address);
        this.blockedAddressSet.put(address, Boolean.TRUE);
    }

    @Override
    public void notifyAsyncOperationRegistered() {
        ++this.pendingAsynchronousOperationsCount;
    }

    @Override
    public void notifyAsyncOperationCompleted(Address owningAddress) {
        Objects.requireNonNull(owningAddress);
        this.pendingAsynchronousOperationsCount = Math.max(0, this.pendingAsynchronousOperationsCount - 1);
        this.blockedAddressSet.remove(owningAddress);
    }

    @Override
    public boolean isAddressBlocked(Address address) {
        return this.blockedAddressSet.containsKey(address);
    }

    private boolean totalPendingAsyncOperationsAtCapacity() {
        return this.maximumPendingAsynchronousOperations > 0 && this.pendingAsynchronousOperationsCount >= this.maximumPendingAsynchronousOperations;
    }

    private boolean hasBlockedAddress() {
        return !this.blockedAddressSet.isEmpty();
    }
}

