/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.functions;

import java.util.Optional;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.statefun.flink.core.functions.PendingAsyncOperations;
import org.apache.flink.statefun.flink.core.message.Message;
import org.apache.flink.statefun.flink.core.message.MessageFactory;
import org.apache.flink.statefun.sdk.Address;
import org.apache.flink.statefun.sdk.AsyncOperationResult;

final class AsyncMessageDecorator<T>
implements Message {
    private final PendingAsyncOperations pendingAsyncOperations;
    private final long futureId;
    private final Message message;
    private final Throwable throwable;
    private final T result;
    private final boolean restored;

    AsyncMessageDecorator(PendingAsyncOperations pendingAsyncOperations, long futureId, Message message, T result, Throwable throwable) {
        this.futureId = futureId;
        this.pendingAsyncOperations = pendingAsyncOperations;
        this.message = message;
        this.throwable = throwable;
        this.result = result;
        this.restored = false;
    }

    AsyncMessageDecorator(PendingAsyncOperations asyncOperationState, Long futureId, Message metadataMessage) {
        this.futureId = futureId;
        this.pendingAsyncOperations = asyncOperationState;
        this.message = metadataMessage;
        this.throwable = null;
        this.result = null;
        this.restored = true;
    }

    @Override
    @Nullable
    public Address source() {
        return this.message.source();
    }

    @Override
    public Address target() {
        return this.message.target();
    }

    @Override
    public Object payload(MessageFactory context, ClassLoader targetClassLoader) {
        AsyncOperationResult.Status status = this.restored ? AsyncOperationResult.Status.UNKNOWN : (this.throwable == null ? AsyncOperationResult.Status.SUCCESS : AsyncOperationResult.Status.FAILURE);
        Object metadata = this.message.payload(context, targetClassLoader);
        return new AsyncOperationResult(metadata, status, this.result, this.throwable);
    }

    @Override
    public OptionalLong isBarrierMessage() {
        return OptionalLong.empty();
    }

    @Override
    public Optional<String> cancellationToken() {
        return this.message.cancellationToken();
    }

    @Override
    public void postApply() {
        this.pendingAsyncOperations.remove(this.source(), this.futureId);
    }

    @Override
    public Message copy(MessageFactory context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(MessageFactory context, DataOutputView target) {
        throw new UnsupportedOperationException();
    }
}

