/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.functions;

import java.util.Objects;
import java.util.function.Consumer;
import org.apache.flink.statefun.flink.core.di.Inject;
import org.apache.flink.statefun.flink.core.di.Label;
import org.apache.flink.statefun.flink.core.di.Lazy;
import org.apache.flink.statefun.flink.core.functions.Partition;
import org.apache.flink.statefun.flink.core.functions.Reductions;
import org.apache.flink.statefun.flink.core.functions.RemoteSink;
import org.apache.flink.statefun.flink.core.message.Message;

final class DelayMessageHandler
implements Consumer<Message> {
    private final RemoteSink remoteSink;
    private final Lazy<Reductions> reductions;
    private final Partition thisPartition;

    @Inject
    public DelayMessageHandler(RemoteSink remoteSink, @Label(value="reductions") Lazy<Reductions> reductions, Partition partition) {
        this.remoteSink = Objects.requireNonNull(remoteSink);
        this.reductions = Objects.requireNonNull(reductions);
        this.thisPartition = Objects.requireNonNull(partition);
    }

    @Override
    public void accept(Message message) {
        if (this.thisPartition.contains(message.target())) {
            this.reductions.get().enqueue(message);
        } else {
            this.remoteSink.accept(message);
        }
    }

    public void onStart() {
    }

    public void onComplete() {
        this.reductions.get().processEnvelopes();
    }
}

