/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.functions;

import java.util.HashMap;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.statefun.flink.core.di.Inject;
import org.apache.flink.statefun.flink.core.di.Label;
import org.apache.flink.statefun.flink.core.message.Message;
import org.apache.flink.statefun.flink.core.state.State;
import org.apache.flink.statefun.sdk.Address;

final class PendingAsyncOperations {
    private final HashMap<Key, Message> memoryStore = new HashMap(32768);
    private final MapState<Long, Message> backingStore;
    private final Consumer<Address> keySetter;

    @Inject
    PendingAsyncOperations(@Label(value="state") State state, @Label(value="async-operations") MapState<Long, Message> backingStore) {
        this(state::setCurrentKey, backingStore);
    }

    @VisibleForTesting
    PendingAsyncOperations(Consumer<Address> keySetter, MapState<Long, Message> backingStore) {
        this.backingStore = Objects.requireNonNull(backingStore);
        this.keySetter = Objects.requireNonNull(keySetter);
    }

    void add(Address owningAddress, long futureId, Message message) {
        Key key = new Key(owningAddress, futureId);
        this.memoryStore.put(key, message);
    }

    void remove(Address owningAddress, long futureId) {
        if (!this.removeFromMemoryStore(owningAddress, futureId)) {
            this.removeFromBackingStore(owningAddress, futureId);
        }
    }

    void flush() {
        this.memoryStore.forEach(this::flushState);
        this.memoryStore.clear();
    }

    private boolean removeFromMemoryStore(Address owningAddress, long futureId) {
        return this.memoryStore.remove(new Key(owningAddress, futureId)) != null;
    }

    private void removeFromBackingStore(Address owningAddress, long futureId) {
        try {
            this.backingStore.remove((Object)futureId);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to remove a registered asynchronous operation for " + owningAddress, e);
        }
    }

    private void flushState(Key key, Message message) {
        this.keySetter.accept(key.owningAddress);
        try {
            this.backingStore.put((Object)key.futureId, (Object)message);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to persisted a previously registered asynchronous operation for " + key.owningAddress, e);
        }
    }

    private static final class Key {
        private final Address owningAddress;
        private final long futureId;
        private final int hash;

        public Key(Address owningAddress, long futureId) {
            this.owningAddress = Objects.requireNonNull(owningAddress);
            this.futureId = futureId;
            this.hash = 37 * owningAddress.hashCode() + Long.hashCode(futureId);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key that = (Key)o;
            if (this.futureId != that.futureId) {
                return false;
            }
            return this.owningAddress.equals((Object)that.owningAddress);
        }
    }
}

