/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.ml.Functions;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.ml.linalg.typeinfo.VectorTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class VectorToArrayExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        List<Vector> vectors = Arrays.asList(Vectors.dense((double[])new double[]{0.0, 0.0}), Vectors.sparse((int)2, (int[])new int[]{1}, (double[])new double[]{1.0}));
        Table inputTable = tEnv.fromDataStream((DataStream)env.fromCollection(vectors, (TypeInformation)VectorTypeInfo.INSTANCE)).as("vector", new String[0]);
        Table outputTable = inputTable.select(new Expression[]{Expressions.$((String)"vector"), (Expression)Functions.vectorToArray((Object[])new Object[]{Expressions.$((String)"vector")}).as("array", new String[0])});
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Vector vector = (Vector)row.getFieldAs("vector");
            Object[] doubleArray = (Double[])row.getFieldAs("array");
            System.out.printf("Input vector: %s\tOutput double array: %s\n", vector, Arrays.toString(doubleArray));
        }
    }
}

