/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.classification;

import org.apache.flink.ml.classification.naivebayes.NaiveBayes;
import org.apache.flink.ml.classification.naivebayes.NaiveBayesModel;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class NaiveBayesExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource trainStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{0.0, 0.0}), 11}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{1.0, 0.0}), 10}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{1.0, 1.0}), 10})});
        Table trainTable = tEnv.fromDataStream((DataStream)trainStream).as("features", new String[]{"label"});
        DataStreamSource predictStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{0.0, 1.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{0.0, 0.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{1.0, 0.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{1.0, 1.0})})});
        Table predictTable = tEnv.fromDataStream((DataStream)predictStream).as("features", new String[0]);
        NaiveBayes naiveBayes = (NaiveBayes)((NaiveBayes)((NaiveBayes)((NaiveBayes)((NaiveBayes)new NaiveBayes().setSmoothing(Double.valueOf(1.0))).setFeaturesCol("features")).setLabelCol("label")).setPredictionCol("prediction")).setModelType("multinomial");
        NaiveBayesModel naiveBayesModel = naiveBayes.fit(new Table[]{trainTable});
        Table outputTable = naiveBayesModel.transform(new Table[]{predictTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            DenseVector features = (DenseVector)row.getField(naiveBayes.getFeaturesCol());
            double predictionResult = (Double)row.getField(naiveBayes.getPredictionCol());
            System.out.printf("Features: %s \tPrediction Result: %s\n", features, predictionResult);
        }
    }
}

