/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import java.util.Arrays;
import org.apache.flink.ml.feature.stringindexer.StringIndexer;
import org.apache.flink.ml.feature.stringindexer.StringIndexerModel;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class StringIndexerExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource trainStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{"a", 1.0}), Row.of((Object[])new Object[]{"b", 1.0}), Row.of((Object[])new Object[]{"b", 2.0}), Row.of((Object[])new Object[]{"c", 0.0}), Row.of((Object[])new Object[]{"d", 2.0}), Row.of((Object[])new Object[]{"a", 2.0}), Row.of((Object[])new Object[]{"b", 2.0}), Row.of((Object[])new Object[]{"b", -1.0}), Row.of((Object[])new Object[]{"a", -1.0}), Row.of((Object[])new Object[]{"c", -1.0})});
        Table trainTable = tEnv.fromDataStream((DataStream)trainStream).as("inputCol1", new String[]{"inputCol2"});
        DataStreamSource predictStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{"a", 2.0}), Row.of((Object[])new Object[]{"b", 1.0}), Row.of((Object[])new Object[]{"c", 2.0})});
        Table predictTable = tEnv.fromDataStream((DataStream)predictStream).as("inputCol1", new String[]{"inputCol2"});
        StringIndexer stringIndexer = (StringIndexer)((StringIndexer)((StringIndexer)new StringIndexer().setStringOrderType("alphabetAsc")).setInputCols(new String[]{"inputCol1", "inputCol2"})).setOutputCols(new String[]{"outputCol1", "outputCol2"});
        StringIndexerModel model = stringIndexer.fit(new Table[]{trainTable});
        Table outputTable = model.transform(new Table[]{predictTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Object[] inputValues = new Object[stringIndexer.getInputCols().length];
            double[] outputValues = new double[stringIndexer.getInputCols().length];
            for (int i = 0; i < inputValues.length; ++i) {
                inputValues[i] = row.getField(stringIndexer.getInputCols()[i]);
                outputValues[i] = (Double)row.getField(stringIndexer.getOutputCols()[i]);
            }
            System.out.printf("Input Values: %s \tOutput Values: %s\n", Arrays.toString(inputValues), Arrays.toString(outputValues));
        }
    }
}

