/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.util.Preconditions;

public class IntermediateDataSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IntermediateDataSetID id;
    private final JobVertex producer;
    @Nullable
    private JobEdge consumer;
    private final ResultPartitionType resultType;

    public IntermediateDataSet(IntermediateDataSetID id, ResultPartitionType resultType, JobVertex producer) {
        this.id = Preconditions.checkNotNull(id);
        this.producer = Preconditions.checkNotNull(producer);
        this.resultType = Preconditions.checkNotNull(resultType);
    }

    public IntermediateDataSetID getId() {
        return this.id;
    }

    public JobVertex getProducer() {
        return this.producer;
    }

    @Nullable
    public JobEdge getConsumer() {
        return this.consumer;
    }

    public ResultPartitionType getResultType() {
        return this.resultType;
    }

    public void addConsumer(JobEdge edge) {
        Preconditions.checkState(this.consumer == null, "Currently one IntermediateDataSet can have at most one consumer.");
        this.consumer = edge;
    }

    public String toString() {
        return "Intermediate Data Set (" + this.id + ")";
    }
}

