/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.Serializable;
import org.apache.flink.runtime.io.network.api.writer.SubtaskStateMapper;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.util.Preconditions;

public class JobEdge
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final JobVertex target;
    private final DistributionPattern distributionPattern;
    private SubtaskStateMapper downstreamSubtaskStateMapper = SubtaskStateMapper.ROUND_ROBIN;
    private SubtaskStateMapper upstreamSubtaskStateMapper = SubtaskStateMapper.ROUND_ROBIN;
    private IntermediateDataSet source;
    private IntermediateDataSetID sourceId;
    private String shipStrategyName;
    private boolean isBroadcast;
    private boolean isForward;
    private String preProcessingOperationName;
    private String operatorLevelCachingDescription;

    public JobEdge(IntermediateDataSet source, JobVertex target, DistributionPattern distributionPattern) {
        if (source == null || target == null || distributionPattern == null) {
            throw new NullPointerException();
        }
        this.target = target;
        this.distributionPattern = distributionPattern;
        this.source = source;
        this.sourceId = source.getId();
    }

    public JobEdge(IntermediateDataSetID sourceId, JobVertex target, DistributionPattern distributionPattern) {
        if (sourceId == null || target == null || distributionPattern == null) {
            throw new NullPointerException();
        }
        this.target = target;
        this.distributionPattern = distributionPattern;
        this.sourceId = sourceId;
    }

    public IntermediateDataSet getSource() {
        return this.source;
    }

    public JobVertex getTarget() {
        return this.target;
    }

    public DistributionPattern getDistributionPattern() {
        return this.distributionPattern;
    }

    public IntermediateDataSetID getSourceId() {
        return this.sourceId;
    }

    public boolean isIdReference() {
        return this.source == null;
    }

    public String getShipStrategyName() {
        return this.shipStrategyName;
    }

    public void setShipStrategyName(String shipStrategyName) {
        this.shipStrategyName = shipStrategyName;
    }

    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.isBroadcast = broadcast;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public void setForward(boolean forward) {
        this.isForward = forward;
    }

    public SubtaskStateMapper getDownstreamSubtaskStateMapper() {
        return this.downstreamSubtaskStateMapper;
    }

    public void setDownstreamSubtaskStateMapper(SubtaskStateMapper downstreamSubtaskStateMapper) {
        this.downstreamSubtaskStateMapper = Preconditions.checkNotNull(downstreamSubtaskStateMapper);
    }

    public SubtaskStateMapper getUpstreamSubtaskStateMapper() {
        return this.upstreamSubtaskStateMapper;
    }

    public void setUpstreamSubtaskStateMapper(SubtaskStateMapper upstreamSubtaskStateMapper) {
        this.upstreamSubtaskStateMapper = Preconditions.checkNotNull(upstreamSubtaskStateMapper);
    }

    public String getPreProcessingOperationName() {
        return this.preProcessingOperationName;
    }

    public void setPreProcessingOperationName(String preProcessingOperationName) {
        this.preProcessingOperationName = preProcessingOperationName;
    }

    public String getOperatorLevelCachingDescription() {
        return this.operatorLevelCachingDescription;
    }

    public void setOperatorLevelCachingDescription(String operatorLevelCachingDescription) {
        this.operatorLevelCachingDescription = operatorLevelCachingDescription;
    }

    public String toString() {
        return String.format("%s --> %s [%s]", this.sourceId, this.target, this.distributionPattern.name());
    }
}

