/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.inference.strategies.StrategyUtils;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.util.Preconditions;

@Internal
public final class FamilyArgumentTypeStrategy
implements ArgumentTypeStrategy {
    private final LogicalTypeFamily expectedFamily;
    @Nullable
    private final Boolean expectedNullability;
    private static final Map<LogicalTypeFamily, LogicalTypeRoot> familyToRoot = new HashMap<LogicalTypeFamily, LogicalTypeRoot>();

    public FamilyArgumentTypeStrategy(LogicalTypeFamily expectedFamily, @Nullable Boolean expectedNullability) {
        this.expectedFamily = Preconditions.checkNotNull(expectedFamily);
        this.expectedNullability = expectedNullability;
    }

    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        DataType actualDataType = callContext.getArgumentDataTypes().get(argumentPos);
        LogicalType actualType = actualDataType.getLogicalType();
        if (actualType instanceof LegacyTypeInformationType) {
            return Optional.of(actualDataType);
        }
        if (Objects.equals(this.expectedNullability, Boolean.FALSE) && actualType.isNullable()) {
            if (throwOnFailure) {
                throw callContext.newValidationError("Unsupported argument type. Expected nullable type of family '%s' but actual type was '%s'.", new Object[]{this.expectedFamily, actualType});
            }
            return Optional.empty();
        }
        if (actualType.getTypeRoot().getFamilies().contains((Object)this.expectedFamily)) {
            return Optional.of(actualDataType);
        }
        LogicalTypeRoot expectedRoot = familyToRoot.get((Object)this.expectedFamily);
        Optional<DataType> inferredDataType = expectedRoot == null ? Optional.empty() : StrategyUtils.findDataType(callContext, false, actualDataType, expectedRoot, this.expectedNullability);
        if (!inferredDataType.isPresent() && throwOnFailure) {
            throw callContext.newValidationError("Unsupported argument type. Expected type of family '%s' but actual type was '%s'.", new Object[]{this.expectedFamily, actualType});
        }
        return inferredDataType;
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        if (Objects.equals(this.expectedNullability, Boolean.TRUE)) {
            return Signature.Argument.of("<" + (Object)((Object)this.expectedFamily) + " NULL>");
        }
        if (Objects.equals(this.expectedNullability, Boolean.FALSE)) {
            return Signature.Argument.of("<" + (Object)((Object)this.expectedFamily) + " NOT NULL>");
        }
        return Signature.Argument.of("<" + (Object)((Object)this.expectedFamily) + ">");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FamilyArgumentTypeStrategy that = (FamilyArgumentTypeStrategy)o;
        return this.expectedFamily == that.expectedFamily && Objects.equals(this.expectedNullability, that.expectedNullability);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expectedFamily, this.expectedNullability});
    }

    static {
        familyToRoot.put(LogicalTypeFamily.NUMERIC, LogicalTypeRoot.TINYINT);
        familyToRoot.put(LogicalTypeFamily.INTEGER_NUMERIC, LogicalTypeRoot.TINYINT);
        familyToRoot.put(LogicalTypeFamily.EXACT_NUMERIC, LogicalTypeRoot.TINYINT);
        familyToRoot.put(LogicalTypeFamily.CHARACTER_STRING, LogicalTypeRoot.VARCHAR);
        familyToRoot.put(LogicalTypeFamily.BINARY_STRING, LogicalTypeRoot.VARBINARY);
        familyToRoot.put(LogicalTypeFamily.APPROXIMATE_NUMERIC, LogicalTypeRoot.DOUBLE);
        familyToRoot.put(LogicalTypeFamily.TIMESTAMP, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE);
        familyToRoot.put(LogicalTypeFamily.TIME, LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE);
    }
}

