/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file;

import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.utils.ObjectSerializer;
import org.apache.flink.table.store.file.utils.OffsetRowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;

public class KeyValueSerializer
extends ObjectSerializer<KeyValue> {
    private static final long serialVersionUID = 1L;
    private final int keyArity;
    private final GenericRowData reusedMeta;
    private final JoinedRowData reusedKeyWithMeta;
    private final JoinedRowData reusedRow;
    private final OffsetRowData reusedKey;
    private final OffsetRowData reusedValue;
    private final KeyValue reusedKv;

    public KeyValueSerializer(RowType keyType, RowType valueType) {
        super(KeyValue.schema(keyType, valueType));
        this.keyArity = keyType.getFieldCount();
        int valueArity = valueType.getFieldCount();
        this.reusedMeta = new GenericRowData(2);
        this.reusedKeyWithMeta = new JoinedRowData();
        this.reusedRow = new JoinedRowData();
        this.reusedKey = new OffsetRowData(this.keyArity, 0);
        this.reusedValue = new OffsetRowData(valueArity, this.keyArity + 2);
        this.reusedKv = new KeyValue().replace(this.reusedKey, -1L, null, this.reusedValue);
    }

    @Override
    public RowData toRow(KeyValue record) {
        return this.toRow(record.key(), record.sequenceNumber(), record.valueKind(), record.value());
    }

    public RowData toRow(RowData key, long sequenceNumber, RowKind valueKind, RowData value) {
        this.reusedMeta.setField(0, (Object)sequenceNumber);
        this.reusedMeta.setField(1, (Object)valueKind.toByteValue());
        return this.reusedRow.replace((RowData)this.reusedKeyWithMeta.replace(key, (RowData)this.reusedMeta), value);
    }

    @Override
    public KeyValue fromRow(RowData row) {
        this.reusedKey.replace(row);
        this.reusedValue.replace(row);
        long sequenceNumber = row.getLong(this.keyArity);
        RowKind valueKind = RowKind.fromByteValue((byte)row.getByte(this.keyArity + 1));
        this.reusedKv.replace(this.reusedKey, sequenceNumber, valueKind, this.reusedValue);
        return this.reusedKv;
    }

    public KeyValue getReusedKv() {
        return this.reusedKv;
    }
}

