/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.store.file.io.FileWriter;
import org.apache.flink.table.store.file.io.SingleFileWriter;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingFileWriter<T, R>
implements FileWriter<T, List<R>> {
    private static final Logger LOG = LoggerFactory.getLogger(RollingFileWriter.class);
    private static final int CHECK_ROLLING_RECORD_CNT = 1000;
    private final Supplier<? extends SingleFileWriter<T, R>> writerFactory;
    private final long targetFileSize;
    private final List<SingleFileWriter<T, R>> openedWriters;
    private final List<R> results;
    private SingleFileWriter<T, R> currentWriter = null;
    private long lengthOfClosedFiles = 0L;
    private long recordCount = 0L;
    private boolean closed = false;

    public RollingFileWriter(Supplier<? extends SingleFileWriter<T, R>> writerFactory, long targetFileSize) {
        this.writerFactory = writerFactory;
        this.targetFileSize = targetFileSize;
        this.openedWriters = new ArrayList<SingleFileWriter<T, R>>();
        this.results = new ArrayList<R>();
    }

    @VisibleForTesting
    public long targetFileSize() {
        return this.targetFileSize;
    }

    @VisibleForTesting
    boolean rollingFile() throws IOException {
        return this.recordCount % 1000L == 0L && this.currentWriter.length() >= this.targetFileSize;
    }

    @Override
    public void write(T row) throws IOException {
        try {
            if (this.currentWriter == null) {
                this.openCurrentWriter();
            }
            this.currentWriter.write(row);
            ++this.recordCount;
            if (this.rollingFile()) {
                this.closeCurrentWriter();
            }
        }
        catch (Throwable e) {
            LOG.warn("Exception occurs when writing file " + (this.currentWriter == null ? null : this.currentWriter.path()) + ". Cleaning up.", e);
            this.abort();
            throw e;
        }
    }

    private void openCurrentWriter() {
        this.currentWriter = this.writerFactory.get();
        this.openedWriters.add(this.currentWriter);
    }

    private void closeCurrentWriter() throws IOException {
        if (this.currentWriter == null) {
            return;
        }
        this.lengthOfClosedFiles += this.currentWriter.length();
        this.currentWriter.close();
        this.results.add(this.currentWriter.result());
        this.currentWriter = null;
    }

    @Override
    public long recordCount() {
        return this.recordCount;
    }

    @Override
    public long length() throws IOException {
        long length = this.lengthOfClosedFiles;
        if (this.currentWriter != null) {
            length += this.currentWriter.length();
        }
        return length;
    }

    @Override
    public void abort() {
        for (FileWriter fileWriter : this.openedWriters) {
            fileWriter.abort();
        }
    }

    @Override
    public List<R> result() {
        Preconditions.checkState((boolean)this.closed, (Object)"Cannot access the results unless close all writers.");
        return this.results;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.closeCurrentWriter();
        }
        catch (IOException e) {
            LOG.warn("Exception occurs when writing file " + this.currentWriter.path() + ". Cleaning up.", (Throwable)e);
            this.abort();
            throw e;
        }
        finally {
            this.closed = true;
        }
    }
}

