/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.connector.kafka.source.enumerator.subscriber;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.table.store.shaded.connector.kafka.source.enumerator.subscriber.KafkaSubscriber;
import org.apache.flink.table.store.shaded.connector.kafka.source.enumerator.subscriber.KafkaSubscriberUtils;
import org.apache.flink.table.store.shaded.org.apache.kafka.clients.admin.AdminClient;
import org.apache.flink.table.store.shaded.org.apache.kafka.clients.admin.TopicDescription;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.TopicPartitionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TopicListSubscriber
implements KafkaSubscriber {
    private static final long serialVersionUID = -6917603843104947866L;
    private static final Logger LOG = LoggerFactory.getLogger(TopicListSubscriber.class);
    private final List<String> topics;

    TopicListSubscriber(List<String> topics) {
        this.topics = topics;
    }

    @Override
    public Set<TopicPartition> getSubscribedTopicPartitions(AdminClient adminClient) {
        LOG.debug("Fetching descriptions for topics: {}", this.topics);
        Map<String, TopicDescription> topicMetadata = KafkaSubscriberUtils.getTopicMetadata(adminClient, new HashSet<String>(this.topics));
        HashSet<TopicPartition> subscribedPartitions = new HashSet<TopicPartition>();
        for (TopicDescription topic : topicMetadata.values()) {
            for (TopicPartitionInfo partition : topic.partitions()) {
                subscribedPartitions.add(new TopicPartition(topic.name(), partition.partition()));
            }
        }
        return subscribedPartitions;
    }
}

