/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.source;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.file.io.DataFileMeta;
import org.apache.flink.table.store.file.io.DataFileMetaSerializer;
import org.apache.flink.table.store.file.utils.SerializationUtils;
import org.apache.flink.table.store.table.source.Split;

public class DataSplit
implements Split {
    private static final long serialVersionUID = 2L;
    private long snapshotId;
    private BinaryRowData partition;
    private int bucket;
    private List<DataFileMeta> files;
    private boolean isIncremental;

    public DataSplit(long snapshotId, BinaryRowData partition, int bucket, List<DataFileMeta> files, boolean isIncremental) {
        this.init(snapshotId, partition, bucket, files, isIncremental);
    }

    private void init(long snapshotId, BinaryRowData partition, int bucket, List<DataFileMeta> files, boolean isIncremental) {
        this.snapshotId = snapshotId;
        this.partition = partition;
        this.bucket = bucket;
        this.files = files;
        this.isIncremental = isIncremental;
    }

    public long snapshotId() {
        return this.snapshotId;
    }

    public BinaryRowData partition() {
        return this.partition;
    }

    public int bucket() {
        return this.bucket;
    }

    public List<DataFileMeta> files() {
        return this.files;
    }

    public boolean isIncremental() {
        return this.isIncremental;
    }

    @Override
    public long rowCount() {
        long rowCount = 0L;
        for (DataFileMeta file : this.files) {
            rowCount += file.rowCount();
        }
        return rowCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSplit split = (DataSplit)o;
        return this.bucket == split.bucket && Objects.equals(this.partition, split.partition) && Objects.equals(this.files, split.files) && this.isIncremental == split.isIncremental;
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.bucket, this.files, this.isIncremental);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.serialize((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        DataSplit split = DataSplit.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        this.init(split.snapshotId, split.partition, split.bucket, split.files, split.isIncremental);
    }

    public void serialize(DataOutputView out) throws IOException {
        out.writeLong(this.snapshotId);
        SerializationUtils.serializeBinaryRow(this.partition, out);
        out.writeInt(this.bucket);
        out.writeInt(this.files.size());
        DataFileMetaSerializer dataFileSer = new DataFileMetaSerializer();
        for (DataFileMeta file : this.files) {
            dataFileSer.serialize(file, out);
        }
        out.writeBoolean(this.isIncremental);
    }

    public static DataSplit deserialize(DataInputView in) throws IOException {
        long snapshotId = in.readLong();
        BinaryRowData partition = SerializationUtils.deserializeBinaryRow(in);
        int bucket = in.readInt();
        int fileNumber = in.readInt();
        ArrayList<DataFileMeta> files = new ArrayList<DataFileMeta>(fileNumber);
        DataFileMetaSerializer dataFileSer = new DataFileMetaSerializer();
        for (int i = 0; i < fileNumber; ++i) {
            files.add((DataFileMeta)dataFileSer.deserialize(in));
        }
        return new DataSplit(snapshotId, partition, bucket, files, in.readBoolean());
    }
}

