/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.sink;

import org.apache.flink.runtime.io.network.api.writer.SubtaskStateMapper;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.table.sink.BucketComputer;

public class BucketStreamPartitioner
extends StreamPartitioner<RowData> {
    private final TableSchema schema;
    private transient BucketComputer computer;
    private transient int numberOfChannels;

    public BucketStreamPartitioner(TableSchema schema) {
        this.schema = schema;
    }

    public void setup(int numberOfChannels) {
        super.setup(numberOfChannels);
        this.computer = new BucketComputer(this.schema);
        this.numberOfChannels = numberOfChannels;
    }

    public int selectChannel(SerializationDelegate<StreamRecord<RowData>> record) {
        return this.computer.bucket((RowData)((StreamRecord)record.getInstance()).getValue()) % this.numberOfChannels;
    }

    public StreamPartitioner<RowData> copy() {
        return this;
    }

    public SubtaskStateMapper getDownstreamSubtaskStateMapper() {
        return SubtaskStateMapper.FULL;
    }

    public boolean isPointwise() {
        return false;
    }

    public String toString() {
        return "bucket-assigner";
    }
}

