/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.source;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.store.connector.source.ContinuousFileStoreSource;
import org.apache.flink.table.store.connector.source.StaticFileStoreSource;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateBuilder;
import org.apache.flink.table.store.file.predicate.PredicateConverter;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.flink.table.store.table.source.snapshot.ContinuousCompactorFollowUpScanner;
import org.apache.flink.table.store.table.source.snapshot.ContinuousCompactorStartingScanner;
import org.apache.flink.table.store.table.source.snapshot.ContinuousDataFileSnapshotEnumerator;
import org.apache.flink.table.store.table.source.snapshot.FullStartingScanner;
import org.apache.flink.table.store.table.source.snapshot.StaticDataFileSnapshotEnumerator;
import org.apache.flink.table.store.table.system.BucketsTable;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class CompactorSourceBuilder {
    private final String tableIdentifier;
    private final FileStoreTable table;
    private boolean isContinuous = false;
    private StreamExecutionEnvironment env;
    @Nullable
    private List<Map<String, String>> specifiedPartitions = null;

    public CompactorSourceBuilder(String tableIdentifier, FileStoreTable table) {
        this.tableIdentifier = tableIdentifier;
        this.table = table;
    }

    public CompactorSourceBuilder withContinuousMode(boolean isContinuous) {
        this.isContinuous = isContinuous;
        return this;
    }

    public CompactorSourceBuilder withEnv(StreamExecutionEnvironment env) {
        this.env = env;
        return this;
    }

    public CompactorSourceBuilder withPartition(Map<String, String> partition) {
        return this.withPartitions(Collections.singletonList(partition));
    }

    public CompactorSourceBuilder withPartitions(List<Map<String, String>> partitions) {
        this.specifiedPartitions = partitions;
        return this;
    }

    private Source<RowData, ?, ?> buildSource(BucketsTable bucketsTable) {
        Predicate partitionPredicate = null;
        if (this.specifiedPartitions != null) {
            partitionPredicate = PredicateBuilder.or((Predicate[])this.specifiedPartitions.stream().map(p -> PredicateConverter.fromMap(p, this.table.rowType())).toArray(Predicate[]::new));
        }
        if (this.isContinuous) {
            return new ContinuousFileStoreSource(bucketsTable, null, partitionPredicate, null, (table, scan, nextSnapshotId) -> new ContinuousDataFileSnapshotEnumerator(table.location(), scan, new ContinuousCompactorStartingScanner(), new ContinuousCompactorFollowUpScanner(), nextSnapshotId));
        }
        return new StaticFileStoreSource(bucketsTable, null, partitionPredicate, null, (table, scan) -> new StaticDataFileSnapshotEnumerator(table.location(), scan, new FullStartingScanner()));
    }

    public DataStreamSource<RowData> build() {
        if (this.env == null) {
            throw new IllegalArgumentException("StreamExecutionEnvironment should not be null.");
        }
        BucketsTable bucketsTable = new BucketsTable(this.table, this.isContinuous);
        RowType produceType = bucketsTable.rowType();
        return this.env.fromSource(this.buildSource(bucketsTable), WatermarkStrategy.noWatermarks(), this.tableIdentifier + "-compact-source", (TypeInformation)InternalTypeInfo.of((LogicalType)produceType));
    }
}

