/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.source;

import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.table.store.connector.source.FileStoreSourceSplit;
import org.apache.flink.table.store.connector.source.FileStoreSourceSplitGenerator;
import org.apache.flink.table.store.connector.source.FlinkSource;
import org.apache.flink.table.store.connector.source.PendingSplitsCheckpoint;
import org.apache.flink.table.store.connector.source.StaticFileStoreSplitEnumerator;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.table.Table;
import org.apache.flink.table.store.table.source.TableScan;

public class SimpleSystemSource
extends FlinkSource {
    private static final long serialVersionUID = 2L;

    public SimpleSystemSource(Table table, @Nullable int[][] projectedFields, @Nullable Predicate predicate, @Nullable Long limit) {
        super(table, projectedFields, predicate, limit);
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public SplitEnumerator<FileStoreSourceSplit, PendingSplitsCheckpoint> restoreEnumerator(SplitEnumeratorContext<FileStoreSourceSplit> context, PendingSplitsCheckpoint checkpoint) {
        TableScan scan = this.table.newScan();
        if (this.predicate != null) {
            scan.withFilter(this.predicate);
        }
        Collection<FileStoreSourceSplit> splits = checkpoint == null ? new FileStoreSourceSplitGenerator().createSplits(scan.plan()) : checkpoint.splits();
        return new StaticFileStoreSplitEnumerator(context, null, splits);
    }
}

