/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.types.logical.RowType;

public abstract class ObjectSerializer<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final RowDataSerializer rowSerializer;

    public ObjectSerializer(RowType rowType) {
        this.rowSerializer = InternalSerializers.create((RowType)rowType);
    }

    public int numFields() {
        return this.rowSerializer.getArity();
    }

    public final void serialize(T record, DataOutputView target) throws IOException {
        this.rowSerializer.serialize(this.toRow(record), target);
    }

    public final T deserialize(DataInputView source) throws IOException {
        return this.fromRow(this.rowSerializer.deserialize(source));
    }

    public final void serializeList(List<T> records, DataOutputView target) throws IOException {
        target.writeInt(records.size());
        for (T t : records) {
            this.serialize(t, target);
        }
    }

    public final byte[] serializeList(List<T> records) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)baos);
        this.serializeList(records, (DataOutputView)view);
        return baos.toByteArray();
    }

    public final List<T> deserializeList(DataInputView source) throws IOException {
        int size = source.readInt();
        ArrayList<T> records = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            records.add(this.deserialize(source));
        }
        return records;
    }

    public final List<T> deserializeList(byte[] bytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputViewStreamWrapper view = new DataInputViewStreamWrapper((InputStream)bais);
        return this.deserializeList((DataInputView)view);
    }

    public abstract RowData toRow(T var1);

    public abstract T fromRow(RowData var1);
}

