/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.codec.binary.Base64;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.security.DelegationTokenIdentifier;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.security.DelegationTokenSecretManager;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge23;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.security.TUGIAssumingTransport;
import org.apache.flink.table.store.shaded.org.apache.thrift.TException;
import org.apache.flink.table.store.shaded.org.apache.thrift.TProcessor;
import org.apache.flink.table.store.shaded.org.apache.thrift.protocol.TProtocol;
import org.apache.flink.table.store.shaded.org.apache.thrift.transport.TSaslClientTransport;
import org.apache.flink.table.store.shaded.org.apache.thrift.transport.TSaslServerTransport;
import org.apache.flink.table.store.shaded.org.apache.thrift.transport.TSocket;
import org.apache.flink.table.store.shaded.org.apache.thrift.transport.TTransport;
import org.apache.flink.table.store.shaded.org.apache.thrift.transport.TTransportException;
import org.apache.flink.table.store.shaded.org.apache.thrift.transport.TTransportFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HadoopThriftAuthBridge {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopThriftAuthBridge.class);
    private static HadoopThriftAuthBridge self = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HadoopThriftAuthBridge getBridge() {
        if (self != null) return self;
        Class<HadoopThriftAuthBridge> clazz = HadoopThriftAuthBridge.class;
        synchronized (HadoopThriftAuthBridge.class) {
            if (self != null) return self;
            self = new HadoopThriftAuthBridge23();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    public Client createClient() {
        return new Client();
    }

    public Client createClientWithConf(String authMethod) {
        UserGroupInformation ugi;
        try {
            ugi = UserGroupInformation.getLoginUser();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to get current login user: " + e, e);
        }
        if (this.loginUserHasCurrentAuthMethod(ugi, authMethod)) {
            LOG.debug("Not setting UGI conf as passed-in authMethod of " + authMethod + " = current.");
            return new Client();
        }
        LOG.debug("Setting UGI conf as passed-in authMethod of " + authMethod + " != current.");
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", authMethod);
        UserGroupInformation.setConfiguration((Configuration)conf);
        return new Client();
    }

    public Server createServer(String keytabFile, String principalConf, String clientConf) throws TTransportException {
        return new Server(keytabFile, principalConf, clientConf);
    }

    public String getServerPrincipal(String principalConfig, String host) throws IOException {
        String serverPrincipal = SecurityUtil.getServerPrincipal((String)principalConfig, (String)host);
        String[] names = SaslRpcServer.splitKerberosName((String)serverPrincipal);
        if (names.length != 3) {
            throw new IOException("Kerberos principal name does NOT have the expected hostname part: " + serverPrincipal);
        }
        return serverPrincipal;
    }

    public String getCanonicalHostName(String hostName) {
        try {
            return InetAddress.getByName(hostName).getCanonicalHostName();
        }
        catch (UnknownHostException exception) {
            LOG.warn("Could not retrieve canonical hostname for " + hostName, (Throwable)exception);
            return hostName;
        }
    }

    public UserGroupInformation getCurrentUGIWithConf(String authMethod) throws IOException {
        UserGroupInformation ugi;
        try {
            ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to get current user: " + e, e);
        }
        if (this.loginUserHasCurrentAuthMethod(ugi, authMethod)) {
            LOG.debug("Not setting UGI conf as passed-in authMethod of " + authMethod + " = current.");
            return ugi;
        }
        LOG.debug("Setting UGI conf as passed-in authMethod of " + authMethod + " != current.");
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", authMethod);
        UserGroupInformation.setConfiguration((Configuration)conf);
        return UserGroupInformation.getCurrentUser();
    }

    private boolean loginUserHasCurrentAuthMethod(UserGroupInformation ugi, String sAuthMethod) {
        UserGroupInformation.AuthenticationMethod authMethod;
        try {
            authMethod = Enum.valueOf(UserGroupInformation.AuthenticationMethod.class, sAuthMethod.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Invalid attribute value for hadoop.security.authentication of " + sAuthMethod, iae);
        }
        LOG.debug("Current authMethod = " + ugi.getAuthenticationMethod());
        return ugi.getAuthenticationMethod().equals((Object)authMethod);
    }

    public abstract Map<String, String> getHadoopSaslProperties(Configuration var1);

    public static class Server {
        protected final UserGroupInformation realUgi;
        protected final UserGroupInformation clientValidationUGI;
        protected DelegationTokenSecretManager secretManager;
        static final ThreadLocal<InetAddress> remoteAddress = new ThreadLocal<InetAddress>(){

            @Override
            protected InetAddress initialValue() {
                return null;
            }
        };
        static final ThreadLocal<UserGroupInformation.AuthenticationMethod> authenticationMethod = new ThreadLocal<UserGroupInformation.AuthenticationMethod>(){

            @Override
            protected UserGroupInformation.AuthenticationMethod initialValue() {
                return UserGroupInformation.AuthenticationMethod.TOKEN;
            }
        };
        private static ThreadLocal<String> remoteUser = new ThreadLocal<String>(){

            @Override
            protected String initialValue() {
                return null;
            }
        };
        private static final ThreadLocal<String> userAuthMechanism = new ThreadLocal<String>(){

            @Override
            protected String initialValue() {
                return SaslRpcServer.AuthMethod.KERBEROS.getMechanismName();
            }
        };

        public Server() throws TTransportException {
            try {
                this.realUgi = UserGroupInformation.getCurrentUser();
                this.clientValidationUGI = UserGroupInformation.getCurrentUser();
            }
            catch (IOException ioe) {
                throw new TTransportException(ioe);
            }
        }

        protected Server(String keytabFile, String principalConf, String clientConf) throws TTransportException {
            if (keytabFile == null || keytabFile.isEmpty()) {
                throw new TTransportException("No keytab specified");
            }
            if (principalConf == null || principalConf.isEmpty()) {
                throw new TTransportException("No principal specified");
            }
            if (clientConf == null || clientConf.isEmpty()) {
                LOG.warn("Client-facing principal not set. Using server-side setting: " + principalConf);
                clientConf = principalConf;
            }
            try {
                LOG.info("Logging in via CLIENT based principal ");
                String kerberosName = SecurityUtil.getServerPrincipal((String)clientConf, (String)"0.0.0.0");
                UserGroupInformation.loginUserFromKeytab((String)kerberosName, (String)keytabFile);
                this.clientValidationUGI = UserGroupInformation.getLoginUser();
                assert (this.clientValidationUGI.isFromKeytab());
                LOG.info("Logging in via SERVER based principal ");
                kerberosName = SecurityUtil.getServerPrincipal((String)principalConf, (String)"0.0.0.0");
                UserGroupInformation.loginUserFromKeytab((String)kerberosName, (String)keytabFile);
                this.realUgi = UserGroupInformation.getLoginUser();
                assert (this.realUgi.isFromKeytab());
            }
            catch (IOException ioe) {
                throw new TTransportException(ioe);
            }
        }

        public void setSecretManager(DelegationTokenSecretManager secretManager) {
            this.secretManager = secretManager;
        }

        public TTransportFactory createTransportFactory(Map<String, String> saslProps) throws TTransportException {
            TSaslServerTransport.Factory transFactory = this.createSaslServerTransportFactory(saslProps);
            return new TUGIAssumingTransportFactory(transFactory, this.clientValidationUGI);
        }

        public TSaslServerTransport.Factory createSaslServerTransportFactory(Map<String, String> saslProps) throws TTransportException {
            String kerberosName = this.clientValidationUGI.getUserName();
            String[] names = SaslRpcServer.splitKerberosName((String)kerberosName);
            if (names.length != 3) {
                throw new TTransportException("Kerberos principal should have 3 parts: " + kerberosName);
            }
            TSaslServerTransport.Factory transFactory = new TSaslServerTransport.Factory();
            transFactory.addServerDefinition(SaslRpcServer.AuthMethod.KERBEROS.getMechanismName(), names[0], names[1], saslProps, (CallbackHandler)new SaslRpcServer.SaslGssCallbackHandler());
            transFactory.addServerDefinition(SaslRpcServer.AuthMethod.DIGEST.getMechanismName(), null, "default", saslProps, new SaslDigestCallbackHandler(this.secretManager));
            return transFactory;
        }

        public TTransportFactory wrapTransportFactory(TTransportFactory transFactory) {
            return new TUGIAssumingTransportFactory(transFactory, this.realUgi);
        }

        public TProcessor wrapProcessor(TProcessor processor) {
            return new TUGIAssumingProcessor(processor, this.secretManager, true);
        }

        public TProcessor wrapNonAssumingProcessor(TProcessor processor) {
            return new TUGIAssumingProcessor(processor, this.secretManager, false);
        }

        public InetAddress getRemoteAddress() {
            return remoteAddress.get();
        }

        public String getRemoteUser() {
            return remoteUser.get();
        }

        public String getUserAuthMechanism() {
            return userAuthMechanism.get();
        }

        static class TUGIAssumingTransportFactory
        extends TTransportFactory {
            private final UserGroupInformation ugi;
            private final TTransportFactory wrapped;

            public TUGIAssumingTransportFactory(TTransportFactory wrapped, UserGroupInformation ugi) {
                assert (wrapped != null);
                assert (ugi != null);
                this.wrapped = wrapped;
                this.ugi = ugi;
            }

            @Override
            public TTransport getTransport(final TTransport trans) {
                return (TTransport)this.ugi.doAs((PrivilegedAction)new PrivilegedAction<TTransport>(){

                    @Override
                    public TTransport run() {
                        return wrapped.getTransport(trans);
                    }
                });
            }
        }

        protected class TUGIAssumingProcessor
        implements TProcessor {
            final TProcessor wrapped;
            DelegationTokenSecretManager secretManager;
            boolean useProxy;

            TUGIAssumingProcessor(TProcessor wrapped, DelegationTokenSecretManager secretManager, boolean useProxy) {
                this.wrapped = wrapped;
                this.secretManager = secretManager;
                this.useProxy = useProxy;
            }

            @Override
            public boolean process(final TProtocol inProt, final TProtocol outProt) throws TException {
                TTransport trans = inProt.getTransport();
                if (!(trans instanceof TSaslServerTransport)) {
                    throw new TException("Unexpected non-SASL transport " + trans.getClass());
                }
                TSaslServerTransport saslTrans = (TSaslServerTransport)trans;
                SaslServer saslServer = saslTrans.getSaslServer();
                String authId = saslServer.getAuthorizationID();
                LOG.debug("AUTH ID ======>" + authId);
                String endUser = authId;
                Socket socket = ((TSocket)saslTrans.getUnderlyingTransport()).getSocket();
                remoteAddress.set(socket.getInetAddress());
                String mechanismName = saslServer.getMechanismName();
                userAuthMechanism.set(mechanismName);
                if (SaslRpcServer.AuthMethod.PLAIN.getMechanismName().equalsIgnoreCase(mechanismName)) {
                    remoteUser.set(endUser);
                    return this.wrapped.process(inProt, outProt);
                }
                authenticationMethod.set(UserGroupInformation.AuthenticationMethod.KERBEROS);
                if (SaslRpcServer.AuthMethod.TOKEN.getMechanismName().equalsIgnoreCase(mechanismName)) {
                    try {
                        TokenIdentifier tokenId = SaslRpcServer.getIdentifier((String)authId, (SecretManager)this.secretManager);
                        endUser = tokenId.getUser().getUserName();
                        authenticationMethod.set(UserGroupInformation.AuthenticationMethod.TOKEN);
                    }
                    catch (SecretManager.InvalidToken e) {
                        throw new TException(e.getMessage());
                    }
                }
                UserGroupInformation clientUgi = null;
                try {
                    if (this.useProxy) {
                        clientUgi = UserGroupInformation.createProxyUser((String)endUser, (UserGroupInformation)UserGroupInformation.getLoginUser());
                        remoteUser.set(clientUgi.getShortUserName());
                        LOG.debug("Set remoteUser :" + (String)remoteUser.get());
                        boolean bl = (Boolean)clientUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                            @Override
                            public Boolean run() {
                                try {
                                    return TUGIAssumingProcessor.this.wrapped.process(inProt, outProt);
                                }
                                catch (TException te) {
                                    throw new RuntimeException(te);
                                }
                            }
                        });
                        return bl;
                    }
                    UserGroupInformation endUserUgi = UserGroupInformation.createRemoteUser((String)endUser);
                    remoteUser.set(endUserUgi.getShortUserName());
                    LOG.debug("Set remoteUser :" + (String)remoteUser.get() + ", from endUser :" + endUser);
                    boolean bl = this.wrapped.process(inProt, outProt);
                    return bl;
                }
                catch (RuntimeException rte) {
                    if (rte.getCause() instanceof TException) {
                        throw (TException)rte.getCause();
                    }
                    throw rte;
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                finally {
                    if (clientUgi != null) {
                        try {
                            FileSystem.closeAllForUGI((UserGroupInformation)clientUgi);
                        }
                        catch (IOException exception) {
                            LOG.error("Could not clean up file-system handles for UGI: " + clientUgi, (Throwable)exception);
                        }
                    }
                }
            }
        }

        static class SaslDigestCallbackHandler
        implements CallbackHandler {
            private final DelegationTokenSecretManager secretManager;

            public SaslDigestCallbackHandler(DelegationTokenSecretManager secretManager) {
                this.secretManager = secretManager;
            }

            private char[] getPassword(DelegationTokenIdentifier tokenid) throws SecretManager.InvalidToken {
                return this.encodePassword(this.secretManager.retrievePassword(tokenid));
            }

            private char[] encodePassword(byte[] password) {
                return new String(Base64.encodeBase64((byte[])password)).toCharArray();
            }

            @Override
            public void handle(Callback[] callbacks) throws SecretManager.InvalidToken, UnsupportedCallbackException {
                NameCallback nc = null;
                PasswordCallback pc = null;
                AuthorizeCallback ac = null;
                for (Callback callback : callbacks) {
                    if (callback instanceof AuthorizeCallback) {
                        ac = (AuthorizeCallback)callback;
                        continue;
                    }
                    if (callback instanceof NameCallback) {
                        nc = (NameCallback)callback;
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        pc = (PasswordCallback)callback;
                        continue;
                    }
                    if (callback instanceof RealmCallback) continue;
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL DIGEST-MD5 Callback");
                }
                if (pc != null) {
                    DelegationTokenIdentifier tokenIdentifier = (DelegationTokenIdentifier)SaslRpcServer.getIdentifier((String)nc.getDefaultName(), (SecretManager)this.secretManager);
                    char[] password = this.getPassword(tokenIdentifier);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("SASL server DIGEST-MD5 callback: setting password for client: " + tokenIdentifier.getUser());
                    }
                    pc.setPassword(password);
                }
                if (ac != null) {
                    String authzid;
                    String authid = ac.getAuthenticationID();
                    if (authid.equals(authzid = ac.getAuthorizationID())) {
                        ac.setAuthorized(true);
                    } else {
                        ac.setAuthorized(false);
                    }
                    if (ac.isAuthorized()) {
                        if (LOG.isDebugEnabled()) {
                            String username = ((DelegationTokenIdentifier)SaslRpcServer.getIdentifier((String)authzid, (SecretManager)this.secretManager)).getUser().getUserName();
                            LOG.debug("SASL server DIGEST-MD5 callback: setting canonicalized client ID: " + username);
                        }
                        ac.setAuthorizedID(authzid);
                    }
                }
            }
        }

        public static enum ServerMode {
            HIVESERVER2,
            METASTORE;

        }
    }

    public static class Client {
        public TTransport createClientTransport(String principalConfig, String host, String methodStr, String tokenStrForm, final TTransport underlyingTransport, final Map<String, String> saslProps) throws IOException {
            final SaslRpcServer.AuthMethod method = (SaslRpcServer.AuthMethod)SaslRpcServer.AuthMethod.valueOf(SaslRpcServer.AuthMethod.class, (String)methodStr);
            TSaslClientTransport saslTransport = null;
            switch (method) {
                case DIGEST: {
                    Token t = new Token();
                    t.decodeFromUrlString(tokenStrForm);
                    saslTransport = new TSaslClientTransport(method.getMechanismName(), null, null, "default", saslProps, new SaslClientCallbackHandler((Token<? extends TokenIdentifier>)t), underlyingTransport);
                    return new TUGIAssumingTransport(saslTransport, UserGroupInformation.getCurrentUser());
                }
                case KERBEROS: {
                    String serverPrincipal = SecurityUtil.getServerPrincipal((String)principalConfig, (String)host);
                    final String[] names = SaslRpcServer.splitKerberosName((String)serverPrincipal);
                    if (names.length != 3) {
                        throw new IOException("Kerberos principal name does NOT have the expected hostname part: " + serverPrincipal);
                    }
                    try {
                        return (TTransport)UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TUGIAssumingTransport>(){

                            @Override
                            public TUGIAssumingTransport run() throws IOException {
                                TSaslClientTransport saslTransport = new TSaslClientTransport(method.getMechanismName(), null, names[0], names[1], saslProps, null, underlyingTransport);
                                return new TUGIAssumingTransport(saslTransport, UserGroupInformation.getCurrentUser());
                            }
                        });
                    }
                    catch (InterruptedException | SaslException se) {
                        throw new IOException("Could not instantiate SASL transport", se);
                    }
                }
            }
            throw new IOException("Unsupported authentication method: " + method);
        }

        private static class SaslClientCallbackHandler
        implements CallbackHandler {
            private final String userName;
            private final char[] userPassword;

            public SaslClientCallbackHandler(Token<? extends TokenIdentifier> token) {
                this.userName = SaslClientCallbackHandler.encodeIdentifier(token.getIdentifier());
                this.userPassword = SaslClientCallbackHandler.encodePassword(token.getPassword());
            }

            @Override
            public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
                NameCallback nc = null;
                PasswordCallback pc = null;
                TextInputCallback rc = null;
                for (Callback callback : callbacks) {
                    if (callback instanceof RealmChoiceCallback) continue;
                    if (callback instanceof NameCallback) {
                        nc = (NameCallback)callback;
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        pc = (PasswordCallback)callback;
                        continue;
                    }
                    if (callback instanceof RealmCallback) {
                        rc = (RealmCallback)callback;
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL client callback");
                }
                if (nc != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("SASL client callback: setting username: " + this.userName);
                    }
                    nc.setName(this.userName);
                }
                if (pc != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("SASL client callback: setting userPassword");
                    }
                    pc.setPassword(this.userPassword);
                }
                if (rc != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("SASL client callback: setting realm: " + rc.getDefaultText());
                    }
                    rc.setText(rc.getDefaultText());
                }
            }

            static String encodeIdentifier(byte[] identifier) {
                return new String(Base64.encodeBase64((byte[])identifier));
            }

            static char[] encodePassword(byte[] password) {
                return new String(Base64.encodeBase64((byte[])password)).toCharArray();
            }
        }
    }
}

