/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferHeader;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.FileRegionBuffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;

public final class BufferReaderWriterUtil {
    public static final int HEADER_LENGTH = 8;
    private static final short HEADER_VALUE_IS_BUFFER = 0;
    private static final short HEADER_VALUE_IS_EVENT = 1;
    private static final short BUFFER_IS_COMPRESSED = 1;
    private static final short BUFFER_IS_NOT_COMPRESSED = 0;

    static boolean writeBuffer(Buffer buffer, ByteBuffer memory) {
        int bufferSize = buffer.getSize();
        if (memory.remaining() < bufferSize + 8) {
            return false;
        }
        memory.putShort(buffer.isBuffer() ? (short)0 : 1);
        memory.putShort(buffer.isCompressed() ? (short)1 : 0);
        memory.putInt(bufferSize);
        memory.put(buffer.getNioBufferReadable());
        return true;
    }

    @Nullable
    static Buffer sliceNextBuffer(ByteBuffer memory) {
        int remaining = memory.remaining();
        if (remaining == 0) {
            return null;
        }
        BufferHeader header = BufferReaderWriterUtil.parseBufferHeader(memory);
        memory.limit(memory.position() + header.getLength());
        ByteBuffer buf = memory.slice();
        memory.position(memory.limit());
        memory.limit(memory.capacity());
        MemorySegment memorySegment = MemorySegmentFactory.wrapOffHeapMemory(buf);
        return new NetworkBuffer(memorySegment, FreeingBufferRecycler.INSTANCE, header.getDataType(), header.isCompressed(), header.getLength());
    }

    static long writeToByteChannel(FileChannel channel, Buffer buffer, ByteBuffer[] arrayWithHeaderBuffer) throws IOException {
        ByteBuffer dataBuffer;
        ByteBuffer headerBuffer = arrayWithHeaderBuffer[0];
        BufferReaderWriterUtil.setByteChannelBufferHeader(buffer, headerBuffer);
        arrayWithHeaderBuffer[1] = dataBuffer = buffer.getNioBufferReadable();
        long bytesExpected = 8 + dataBuffer.remaining();
        BufferReaderWriterUtil.writeBuffers(channel, bytesExpected, arrayWithHeaderBuffer);
        return bytesExpected;
    }

    static long writeToByteChannelIfBelowSize(FileChannel channel, Buffer buffer, ByteBuffer[] arrayWithHeaderBuffer, long bytesLeft) throws IOException {
        if (bytesLeft >= (long)(8 + buffer.getSize())) {
            return BufferReaderWriterUtil.writeToByteChannel(channel, buffer, arrayWithHeaderBuffer);
        }
        return -1L;
    }

    public static void setByteChannelBufferHeader(Buffer buffer, ByteBuffer header) {
        header.clear();
        header.putShort(buffer.isBuffer() ? (short)0 : 1);
        header.putShort(buffer.isCompressed() ? (short)1 : 0);
        header.putInt(buffer.getSize());
        header.flip();
    }

    @Nullable
    static Buffer readFileRegionFromByteChannel(FileChannel channel, ByteBuffer headerBuffer) throws IOException {
        headerBuffer.clear();
        if (!BufferReaderWriterUtil.tryReadByteBuffer(channel, headerBuffer)) {
            return null;
        }
        headerBuffer.flip();
        BufferHeader header = BufferReaderWriterUtil.parseBufferHeader(headerBuffer);
        long position = channel.position();
        channel.position(position + (long)header.getLength());
        return new FileRegionBuffer(channel, position, header.getLength(), header.getDataType(), header.isCompressed());
    }

    @Nullable
    public static Buffer readFromByteChannel(FileChannel channel, ByteBuffer headerBuffer, MemorySegment memorySegment, BufferRecycler bufferRecycler) throws IOException {
        ByteBuffer targetBuf;
        BufferHeader header;
        headerBuffer.clear();
        if (!BufferReaderWriterUtil.tryReadByteBuffer(channel, headerBuffer)) {
            return null;
        }
        headerBuffer.flip();
        try {
            header = BufferReaderWriterUtil.parseBufferHeader(headerBuffer);
            targetBuf = memorySegment.wrap(0, header.getLength());
        }
        catch (IllegalArgumentException | BufferUnderflowException e) {
            BufferReaderWriterUtil.throwCorruptDataException();
            return null;
        }
        BufferReaderWriterUtil.readByteBufferFully(channel, targetBuf);
        Buffer.DataType dataType = header.getDataType();
        return new NetworkBuffer(memorySegment, bufferRecycler, dataType, header.isCompressed(), header.getLength());
    }

    public static ByteBuffer allocatedHeaderBuffer() {
        ByteBuffer bb = ByteBuffer.allocateDirect(8);
        BufferReaderWriterUtil.configureByteBuffer(bb);
        return bb;
    }

    public static void positionToNextBuffer(FileChannel channel, ByteBuffer headerBuffer) throws IOException {
        headerBuffer.clear();
        if (!BufferReaderWriterUtil.tryReadByteBuffer(channel, headerBuffer)) {
            BufferReaderWriterUtil.throwCorruptDataException();
        }
        headerBuffer.flip();
        try {
            headerBuffer.getShort();
            headerBuffer.getShort();
            long bufferSize = headerBuffer.getInt();
            channel.position(channel.position() + bufferSize);
        }
        catch (IllegalArgumentException | BufferUnderflowException e) {
            BufferReaderWriterUtil.throwCorruptDataException();
        }
    }

    static ByteBuffer[] allocatedWriteBufferArray() {
        return new ByteBuffer[]{BufferReaderWriterUtil.allocatedHeaderBuffer(), null};
    }

    private static boolean tryReadByteBuffer(FileChannel channel, ByteBuffer b) throws IOException {
        if (channel.read(b) == -1) {
            return false;
        }
        while (b.hasRemaining()) {
            if (channel.read(b) != -1) continue;
            BufferReaderWriterUtil.throwPrematureEndOfFile();
        }
        return true;
    }

    static void readByteBufferFully(FileChannel channel, ByteBuffer b) throws IOException {
        do {
            if (channel.read(b) != -1) continue;
            BufferReaderWriterUtil.throwPrematureEndOfFile();
        } while (b.hasRemaining());
    }

    public static void readByteBufferFully(FileChannel channel, ByteBuffer b, long position) throws IOException {
        do {
            int numRead;
            if ((numRead = channel.read(b, position)) == -1) {
                BufferReaderWriterUtil.throwPrematureEndOfFile();
            }
            position += (long)numRead;
        } while (b.hasRemaining());
    }

    static void writeBuffer(FileChannel channel, ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            channel.write(buffer);
        }
    }

    public static void writeBuffers(FileChannel channel, long bytesExpected, ByteBuffer ... buffers) throws IOException {
        if (bytesExpected > channel.write(buffers)) {
            for (ByteBuffer buffer : buffers) {
                BufferReaderWriterUtil.writeBuffer(channel, buffer);
            }
        }
    }

    static BufferHeader parseBufferHeader(ByteBuffer headerBuffer) {
        BufferReaderWriterUtil.configureByteBuffer(headerBuffer);
        boolean isEvent = headerBuffer.getShort() == 1;
        boolean isCompressed = headerBuffer.getShort() == 1;
        int length = headerBuffer.getInt();
        return new BufferHeader(isCompressed, length, isEvent ? Buffer.DataType.EVENT_BUFFER : Buffer.DataType.DATA_BUFFER);
    }

    private static void throwPrematureEndOfFile() throws IOException {
        throw new IOException("The spill file is corrupt: premature end of file");
    }

    private static void throwCorruptDataException() throws IOException {
        throw new IOException("The spill file is corrupt: buffer size and boundaries invalid");
    }

    static void configureByteBuffer(ByteBuffer buffer) {
        buffer.order(ByteOrder.nativeOrder());
    }
}

