/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class AbstractChannelStateHandle<Info>
implements StateObject {
    private static final long serialVersionUID = 1L;
    private final Info info;
    private final StreamStateHandle delegate;
    private final List<Long> offsets;
    private final long size;
    private final int subtaskIndex;

    AbstractChannelStateHandle(StreamStateHandle delegate, List<Long> offsets, int subtaskIndex, Info info, long size) {
        this.subtaskIndex = subtaskIndex;
        this.info = Preconditions.checkNotNull(info);
        this.delegate = Preconditions.checkNotNull(delegate);
        this.offsets = Preconditions.checkNotNull(offsets);
        this.size = size;
    }

    public static Set<StreamStateHandle> collectUniqueDelegates(Collection<? extends AbstractChannelStateHandle<?>> ... collections) {
        HashSet<StreamStateHandle> result = new HashSet<StreamStateHandle>();
        for (Collection<AbstractChannelStateHandle<?>> collection : collections) {
            for (AbstractChannelStateHandle<?> handle : collection) {
                result.add(handle.getDelegate());
            }
        }
        return result;
    }

    @Override
    public void discardState() throws Exception {
        this.delegate.discardState();
    }

    @Override
    public long getStateSize() {
        return this.size;
    }

    public List<Long> getOffsets() {
        return this.offsets;
    }

    public StreamStateHandle getDelegate() {
        return this.delegate;
    }

    public Info getInfo() {
        return this.info;
    }

    public int getSubtaskIndex() {
        return this.subtaskIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractChannelStateHandle that = (AbstractChannelStateHandle)o;
        return this.subtaskIndex == that.subtaskIndex && this.info.equals(that.info) && this.delegate.equals(that.delegate) && this.offsets.equals(that.offsets);
    }

    public int hashCode() {
        return Objects.hash(this.subtaskIndex, this.info, this.delegate, this.offsets);
    }

    public String toString() {
        return "AbstractChannelStateHandle{info=" + this.info + ", delegate=" + this.delegate + ", offsets=" + this.offsets + '}';
    }

    public static class StateContentMetaInfo {
        private final List<Long> offsets;
        private long size = 0L;

        public StateContentMetaInfo() {
            this(new ArrayList<Long>(), 0L);
        }

        public StateContentMetaInfo(List<Long> offsets, long size) {
            this.offsets = offsets;
            this.size = size;
        }

        public void withDataAdded(long offset, long size) {
            this.offsets.add(offset);
            this.size += size;
        }

        public List<Long> getOffsets() {
            return Collections.unmodifiableList(this.offsets);
        }

        public long getSize() {
            return this.size;
        }
    }
}

