/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class CatalogPartitionSpec {
    private final Map<String, String> partitionSpec;

    public CatalogPartitionSpec(Map<String, String> partitionSpec) {
        Preconditions.checkNotNull(partitionSpec, "partitionSpec cannot be null");
        this.partitionSpec = Collections.unmodifiableMap(partitionSpec);
    }

    public Map<String, String> getPartitionSpec() {
        return this.partitionSpec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogPartitionSpec that = (CatalogPartitionSpec)o;
        return this.partitionSpec.equals(that.partitionSpec);
    }

    public int hashCode() {
        return Objects.hash(this.partitionSpec);
    }

    public String toString() {
        return "CatalogPartitionSpec{" + this.partitionSpec + '}';
    }
}

