/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.stream.Collectors;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.AlterTableOperation;

public class AlterTableOptionsOperation
extends AlterTableOperation {
    private final CatalogTable catalogTable;

    public AlterTableOptionsOperation(ObjectIdentifier tableIdentifier, CatalogTable catalogTable) {
        super(tableIdentifier);
        this.catalogTable = catalogTable;
    }

    public CatalogTable getCatalogTable() {
        return this.catalogTable;
    }

    @Override
    public String asSummaryString() {
        String description = this.catalogTable.getOptions().entrySet().stream().map(entry -> OperationUtils.formatParameter((String)entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        return String.format("ALTER TABLE %s SET (%s)", this.tableIdentifier.asSummaryString(), description);
    }
}

