/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate;

import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.operators.aggregate.RecordCounter;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.util.StateConfigUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;

public class GroupAggFunction
extends KeyedProcessFunction<RowData, RowData, RowData> {
    private static final long serialVersionUID = -4767158666069797704L;
    private final GeneratedAggsHandleFunction genAggsHandler;
    private final GeneratedRecordEqualiser genRecordEqualiser;
    private final LogicalType[] accTypes;
    private final RecordCounter recordCounter;
    private final boolean generateUpdateBefore;
    private final long stateRetentionTime;
    private transient JoinedRowData resultRow = null;
    private transient AggsHandleFunction function = null;
    private transient RecordEqualiser equaliser = null;
    private transient ValueState<RowData> accState = null;

    public GroupAggFunction(GeneratedAggsHandleFunction genAggsHandler, GeneratedRecordEqualiser genRecordEqualiser, LogicalType[] accTypes, int indexOfCountStar, boolean generateUpdateBefore, long stateRetentionTime) {
        this.genAggsHandler = genAggsHandler;
        this.genRecordEqualiser = genRecordEqualiser;
        this.accTypes = accTypes;
        this.recordCounter = RecordCounter.of(indexOfCountStar);
        this.generateUpdateBefore = generateUpdateBefore;
        this.stateRetentionTime = stateRetentionTime;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        StateTtlConfig ttlConfig = StateConfigUtil.createTtlConfig(this.stateRetentionTime);
        this.function = (AggsHandleFunction)this.genAggsHandler.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.function.open(new PerKeyStateDataViewStore(this.getRuntimeContext(), ttlConfig));
        this.equaliser = (RecordEqualiser)this.genRecordEqualiser.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        InternalTypeInfo<RowData> accTypeInfo = InternalTypeInfo.ofFields(this.accTypes);
        ValueStateDescriptor<RowData> accDesc = new ValueStateDescriptor<RowData>("accState", accTypeInfo);
        if (ttlConfig.isEnabled()) {
            accDesc.enableTimeToLive(ttlConfig);
        }
        this.accState = this.getRuntimeContext().getState(accDesc);
        this.resultRow = new JoinedRowData();
    }

    @Override
    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        boolean firstRow;
        RowData currentKey = (RowData)ctx.getCurrentKey();
        RowData accumulators = this.accState.value();
        if (null == accumulators) {
            if (RowDataUtil.isRetractMsg(input)) {
                return;
            }
            firstRow = true;
            accumulators = this.function.createAccumulators();
        } else {
            firstRow = false;
        }
        this.function.setAccumulators(accumulators);
        RowData prevAggValue = this.function.getValue();
        if (RowDataUtil.isAccumulateMsg(input)) {
            this.function.accumulate(input);
        } else {
            this.function.retract(input);
        }
        RowData newAggValue = this.function.getValue();
        accumulators = this.function.getAccumulators();
        if (!this.recordCounter.recordCountIsZero(accumulators)) {
            this.accState.update(accumulators);
            if (!firstRow) {
                if (this.stateRetentionTime <= 0L && this.equaliser.equals(prevAggValue, newAggValue)) {
                    return;
                }
                if (this.generateUpdateBefore) {
                    this.resultRow.replace(currentKey, prevAggValue).setRowKind(RowKind.UPDATE_BEFORE);
                    out.collect(this.resultRow);
                }
                this.resultRow.replace(currentKey, newAggValue).setRowKind(RowKind.UPDATE_AFTER);
            } else {
                this.resultRow.replace(currentKey, newAggValue).setRowKind(RowKind.INSERT);
            }
            out.collect(this.resultRow);
        } else {
            if (!firstRow) {
                this.resultRow.replace(currentKey, prevAggValue).setRowKind(RowKind.DELETE);
                out.collect(this.resultRow);
            }
            this.accState.clear();
            this.function.cleanup();
        }
    }

    @Override
    public void close() throws Exception {
        if (this.function != null) {
            this.function.close();
        }
    }
}

