/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.predicate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.shaded.guava30.com.google.common.collect.ImmutableSet;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.store.file.predicate.Equal;
import org.apache.flink.table.store.file.predicate.In;
import org.apache.flink.table.store.file.predicate.LeafPredicate;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateBuilder;
import org.apache.flink.table.store.table.sink.BucketComputer;
import org.apache.flink.table.types.logical.RowType;

@ThreadSafe
public class BucketSelector
implements Serializable {
    public static final int MAX_VALUES = 1000;
    private static final long serialVersionUID = 1L;
    private final int[] hashCodes;
    private final Map<Integer, Set<Integer>> buckets = new ConcurrentHashMap<Integer, Set<Integer>>();

    public BucketSelector(int[] hashCodes) {
        this.hashCodes = hashCodes;
    }

    public boolean select(int bucket, int numBucket) {
        return this.buckets.computeIfAbsent(numBucket, k -> this.createBucketSet(numBucket)).contains(bucket);
    }

    @VisibleForTesting
    int[] hashCodes() {
        return this.hashCodes;
    }

    @VisibleForTesting
    Set<Integer> createBucketSet(int numBucket) {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (int hash : this.hashCodes) {
            builder.add((Object)BucketComputer.bucket(hash, numBucket));
        }
        return builder.build();
    }

    public static Optional<BucketSelector> create(Predicate bucketPredicate, RowType bucketKeyType) {
        List[] bucketValues = new List[bucketKeyType.getFieldCount()];
        block0: for (Predicate predicate : PredicateBuilder.splitAnd(bucketPredicate)) {
            Integer reference = null;
            ArrayList values = new ArrayList();
            for (Predicate orPredicate : PredicateBuilder.splitOr(predicate)) {
                if (!(orPredicate instanceof LeafPredicate)) continue block0;
                LeafPredicate leaf = (LeafPredicate)orPredicate;
                if (reference != null && reference.intValue() != leaf.index()) continue block0;
                reference = leaf.index();
                if (!leaf.function().equals(Equal.INSTANCE) && !leaf.function().equals(In.INSTANCE)) continue block0;
                values.addAll(leaf.literals().stream().filter(Objects::nonNull).collect(Collectors.toList()));
            }
            if (reference == null) continue;
            if (bucketValues[reference] != null) {
                return Optional.empty();
            }
            bucketValues[reference.intValue()] = values;
        }
        int rowCount = 1;
        for (List values : bucketValues) {
            if (values == null) {
                return Optional.empty();
            }
            if ((rowCount *= values.size()) <= 1000) continue;
            return Optional.empty();
        }
        RowDataSerializer rowDataSerializer = new RowDataSerializer(bucketKeyType);
        ArrayList hashCodes = new ArrayList();
        BucketSelector.assembleRows(bucketValues, columns -> hashCodes.add(BucketSelector.hash(columns, serializer)), new ArrayList<Object>(), 0);
        return Optional.of(new BucketSelector(hashCodes.stream().mapToInt(i -> i).toArray()));
    }

    private static int hash(List<Object> columns, RowDataSerializer serializer) {
        BinaryRowData binaryRow = serializer.toBinaryRow(GenericRowData.of(columns.toArray()));
        return BucketComputer.hashcode(binaryRow);
    }

    private static void assembleRows(List<Object>[] rowValues, Consumer<List<Object>> consumer, List<Object> stack, int columnIndex) {
        List<Object> columnValues = rowValues[columnIndex];
        for (Object value : columnValues) {
            stack.add(value);
            if (columnIndex == rowValues.length - 1) {
                consumer.accept(stack);
            } else {
                BucketSelector.assembleRows(rowValues, consumer, stack, columnIndex + 1);
            }
            stack.remove(stack.size() - 1);
        }
    }
}

