/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.ParquetWriter;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class ParquetBulkWriter<T>
implements BulkWriter<T> {
    private final ParquetWriter<T> parquetWriter;

    public ParquetBulkWriter(ParquetWriter<T> parquetWriter) {
        this.parquetWriter = Preconditions.checkNotNull(parquetWriter, "parquetWriter");
    }

    @Override
    public void addElement(T datum) throws IOException {
        this.parquetWriter.write(datum);
    }

    @Override
    public void flush() {
    }

    @Override
    public void finish() throws IOException {
        this.parquetWriter.close();
    }
}

