/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.PositionOutputStreamAdapter;
import org.apache.flink.table.store.shaded.org.apache.parquet.io.OutputFile;
import org.apache.flink.table.store.shaded.org.apache.parquet.io.PositionOutputStream;
import org.apache.flink.util.Preconditions;

@Internal
class StreamOutputFile
implements OutputFile {
    private static final long DEFAULT_BLOCK_SIZE = 0x4000000L;
    private final FSDataOutputStream stream;
    private final AtomicBoolean used;

    StreamOutputFile(FSDataOutputStream stream) {
        this.stream = Preconditions.checkNotNull(stream);
        this.used = new AtomicBoolean(false);
    }

    @Override
    public PositionOutputStream create(long blockSizeHint) {
        if (this.used.compareAndSet(false, true)) {
            return new PositionOutputStreamAdapter(this.stream);
        }
        throw new IllegalStateException("A stream against this file was already created.");
    }

    @Override
    public PositionOutputStream createOrOverwrite(long blockSizeHint) {
        return this.create(blockSizeHint);
    }

    @Override
    public boolean supportsBlockSize() {
        return false;
    }

    @Override
    public long defaultBlockSize() {
        return 0x4000000L;
    }
}

