/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.spark;

import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.operation.Lock;
import org.apache.flink.table.store.filesystem.FileSystems;
import org.apache.flink.table.store.spark.SparkCaseSensitiveConverter;
import org.apache.flink.table.store.spark.SparkTable;
import org.apache.flink.table.store.table.FileStoreTableFactory;
import org.apache.spark.sql.connector.catalog.SessionConfigSupport;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class SparkSource
implements DataSourceRegister,
SessionConfigSupport {
    private static final String SHORT_NAME = "tablestore";

    public String shortName() {
        return SHORT_NAME;
    }

    public StructType inferSchema(CaseInsensitiveStringMap options) {
        return null;
    }

    public Transform[] inferPartitioning(CaseInsensitiveStringMap options) {
        return null;
    }

    public boolean supportsExternalMetadata() {
        return true;
    }

    public Table getTable(StructType schema, Transform[] partitioning, Map<String, String> options) {
        Configuration configuration = Configuration.fromMap(SparkCaseSensitiveConverter.convert(options));
        FileSystems.initialize(CoreOptions.path(options), configuration);
        return new SparkTable(FileStoreTableFactory.create(Configuration.fromMap(options)), Lock.emptyFactory(), configuration);
    }

    public String keyPrefix() {
        return SHORT_NAME;
    }
}

